/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.util;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.IAGSWSDLConstants;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;
import org.apache.commons.io.IOUtils;

public class UserServiceCall
implements IAGSWSDLConstants {
    private HashMap paramMap;
    private HashMap attributeMap;
    private String url;
    private String body;
    private String portName;
    private String serviceName;
    private String operationName;
    private String taskName;

    public UserServiceCall(String taskName, HashMap paramMap, HashMap attributeMap, String body) {
        this.attributeMap = attributeMap;
        this.paramMap = paramMap;
        this.url = (String)paramMap.get("target");
        this.body = body;
        this.portName = (String)paramMap.get("portname");
        this.serviceName = (String)paramMap.get("servicename");
        this.operationName = (String)paramMap.get("operationname");
    }

    public void invoke() throws AgentServiceException {
        try {
            Call call = new Call(new URL(this.url));
            call.setUseSOAPAction(true);
            call.setSOAPActionURI("http://developer.cognos.com/schemas/humanTaskService/1");
            call.setOperationName(this.operationName);
            call.setTimeout(new Integer(360000));
            SOAPEnvelope env = this.makeSoapEnvelope();
            call.invoke(env);
        }
        catch (MalformedURLException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_URI_ERROR, new Object[]{this.taskName});
        }
        catch (Exception e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e});
        }
    }

    private SOAPEnvelope makeSoapEnvelope() throws IOException {
        SOAPEnvelope soapEnv = new SOAPEnvelope((SOAPConstants)SOAPConstants.SOAP12_CONSTANTS);
        BiBusHeader header = (BiBusHeader)this.attributeMap.get("BIBUS_HEADER");
        SOAPHeaderElement hdr = new SOAPHeaderElement("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
        soapEnv.addHeader(hdr);
        SOAPBodyElement sbe = new SOAPBodyElement(IOUtils.toInputStream((String)this.body, (String)"UTF-8"));
        soapEnv.addBodyElement(sbe);
        return soapEnv;
    }
}

