/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.xhtml;

import com.cognos.asv.formatters.Formatter;
import java.util.Hashtable;
import java.util.Iterator;
import org.xml.sax.Attributes;

public class XHTMLAttributes {
    private Hashtable m_attributes;

    public XHTMLAttributes(Attributes attributes) {
        if (attributes != null && attributes.getLength() > 0) {
            this.m_attributes = this.buildHashTable(attributes.getLength());
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeQName = attributes.getQName(i);
                String attributeValue = attributes.getValue(i);
                this.m_attributes.put(attributeQName, attributeValue);
            }
        }
    }

    public boolean hasAttribute(String attribute_name) {
        return this.m_attributes == null ? false : this.m_attributes.containsKey(attribute_name);
    }

    public boolean hasAttributeValue(String attribute_value) {
        return this.m_attributes == null ? false : this.m_attributes.containsValue(attribute_value);
    }

    public String getAttribute(String attribute_name) {
        String ret_value = null;
        if (this.hasAttribute(attribute_name)) {
            ret_value = (String)this.m_attributes.get(attribute_name);
        }
        return ret_value;
    }

    public void setAttribute(String attribute_name, String value) {
        if (this.m_attributes == null) {
            this.m_attributes = this.buildHashTable(2);
        }
        this.m_attributes.put(attribute_name, value);
    }

    public String getText(Formatter formatter) {
        StringBuffer ret_value = new StringBuffer("");
        if (this.m_attributes != null) {
            for (String key : this.m_attributes.keySet()) {
                String value = (String)this.m_attributes.get(key);
                ret_value.append(" ");
                ret_value.append(formatter.format(key));
                ret_value.append("=\"");
                ret_value.append(formatter.format(value));
                ret_value.append("\"");
            }
        }
        return ret_value.toString();
    }

    public Iterator attributeNameIterator() {
        return this.m_attributes.keySet().iterator();
    }

    XHTMLAttributes shallowCopy() {
        XHTMLAttributes copy = new XHTMLAttributes(null);
        if (this.m_attributes != null) {
            for (String key : this.m_attributes.keySet()) {
                String value = (String)this.m_attributes.get(key);
                copy.setAttribute(key, value);
            }
        }
        return copy;
    }

    private Hashtable buildHashTable(int capacity) {
        return new Hashtable(capacity * 2);
    }
}

