/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.xhtml.descriptors;

import com.cognos.asv.formatters.HTMLEncodeFormatter;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.RssOption;
import com.cognos.developer.schemas.bibus._3.RssOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.RssOptionEnum;
import com.cognos.developer.schemas.bibus._3.RssOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.RssOptionString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class RssOptionDescriptor {
    private String m_headline;
    private String m_description;
    private String m_screenTip;
    private String m_target;
    private String m_URI;
    private boolean m_delete = false;
    private boolean m_create = false;

    public RssOptionDescriptor(Option[] options) {
        this.process(options);
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getHeadline() {
        return this.m_headline;
    }

    public String getTarget() {
        return this.m_target;
    }

    public String getURI() {
        return this.m_URI;
    }

    public String getScreenTip() {
        return this.m_screenTip;
    }

    public boolean isDelete() {
        return this.m_delete;
    }

    public boolean isCreate() {
        return this.m_create;
    }

    private void process(Option[] options) {
        for (int i = 0; i < options.length; ++i) {
            if (!(options[i] instanceof RssOption)) continue;
            RssOption rssOption = (RssOption)options[i];
            if (rssOption.getName().equals((Object)RssOptionEnum.itemDescription)) {
                this.m_description = this.buildHTML(((RssOptionString)rssOption).getValue());
                continue;
            }
            if (rssOption.getName().equals((Object)RssOptionEnum.itemName)) {
                this.m_headline = this.buildHTML(((RssOptionString)rssOption).getValue());
                continue;
            }
            if (rssOption.getName().equals((Object)RssOptionEnum.itemScreenTip)) {
                this.m_screenTip = this.buildHTML(((RssOptionString)rssOption).getValue());
                continue;
            }
            if (rssOption.getName().equals((Object)RssOptionEnum.itemTarget)) {
                this.m_target = ((RssOptionSearchPathSingleObject)rssOption).getValue().get_value();
                continue;
            }
            if (rssOption.getName().equals((Object)RssOptionEnum.itemURI)) {
                this.m_URI = ((RssOptionAnyURI)rssOption).getValue();
                continue;
            }
            if (rssOption.getName().equals((Object)RssOptionEnum.deleteItem)) {
                this.m_delete = true;
                continue;
            }
            if (!rssOption.getName().equals((Object)RssOptionEnum.createItem)) continue;
            this.m_create = true;
        }
    }

    private String buildHTML(String txt) {
        StringBuffer buffer = new StringBuffer(txt.length());
        StringReader string_reader = new StringReader(txt);
        BufferedReader line_reader = new BufferedReader(string_reader);
        HTMLEncodeFormatter formatter = new HTMLEncodeFormatter();
        String line = null;
        try {
            while ((line = line_reader.readLine()) != null) {
                buffer.append(formatter.format(line));
                buffer.append("<br/>");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.toString();
    }
}

