/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ags;

import com.cognos.ags.AGSWSDLResult;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.util.XTSObjectCache;
import java.io.Reader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.apache.wsif.util.WSIFUtils;

public class AGSWSDLRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    private String m_sIdentifier = null;
    private Locale m_locale = null;
    private XTSObjectCache m_cache = new XTSObjectCache();
    private Object m_oMutexObj = new Object();

    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_locale = env.getLocale();
        this.m_sIdentifier = identifier;
    }

    public void terminate() throws XTSInstructionException {
        try {
            this.m_cache.clearCache();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        AGSWSDLResult result;
        block13: {
            Definition def = null;
            result = null;
            String target = (String)instAtts.get("target");
            if (target == null || target.length() == 0) {
                throw new XTSInstructionException("protocol.missingtarget");
            }
            try {
                URL wsdlLocation = new URL(target);
                result = (AGSWSDLResult)this.m_cache.getObject(target);
                if (result != null) break block13;
                Object object = this.m_oMutexObj;
                synchronized (object) {
                    result = (AGSWSDLResult)this.m_cache.getObject(target);
                    if (result == null) {
                        try {
                            def = WSIFUtils.readWSDL(null, (String)wsdlLocation.toString());
                            result = new AGSWSDLResult(env, target, def);
                        }
                        catch (WSDLException e) {
                            if (e.getFaultCode().equals("INVALID_WSDL")) {
                                throw new XTSInstructionException(I18NUtil.getMessage((I18NCode)AsvI18NCode.MSG_ASV_WS_URI_ERROR, (Object)target, (Locale)this.m_locale));
                            }
                            if (e.getFaultCode().equals("PARSER_ERROR")) {
                                throw new XTSInstructionException(I18NUtil.getMessage((I18NCode)AsvI18NCode.MSG_ASV_WS_PARSE_ERROR, (Object)target, (Locale)this.m_locale));
                            }
                            Throwable t = e.getTargetException();
                            if (t instanceof ConnectException) {
                                throw new XTSInstructionException(I18NUtil.getMessage((I18NCode)AsvI18NCode.MSG_ASV_WS_URI_ERROR, (Object)target, (Locale)this.m_locale));
                            }
                            throw new XTSInstructionException(I18NUtil.getMessage((I18NCode)AsvI18NCode.MSG_ASV_WS_SERVICE_ERROR, (Object)(target + "[" + t.getMessage() + "]"), (Locale)this.m_locale));
                        }
                        this.m_cache.addObject(target, (Object)result);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new XTSInstructionException(I18NUtil.getMessage((I18NCode)AsvI18NCode.MSG_ASV_GENERAL_ERROR, (Object)e.getLocalizedMessage(), (Locale)this.m_locale), (Throwable)e);
            }
            catch (MalformedURLException e1) {
                throw new XTSInstructionException(I18NUtil.getMessage((I18NCode)AsvI18NCode.MSG_ASV_WS_URI_ERROR, (Object)target, (Locale)this.m_locale), (Throwable)e1);
            }
        }
        return result;
    }
}

