/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ags;

import com.cognos.ags.AGSComplexTypeHolder;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.util.ByteArrayIOStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.xml.WSDLLocator;
import org.apache.wsif.WSIFException;
import org.apache.wsif.schema.Parser;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.WSIFWSDLLocatorImpl;

public final class AGSWSDLResult
implements IXTSOutputableInstructionResult {
    private static final String OPEN_ELEMENT_START = "<";
    private static final String ELEMENT_END = ">";
    private static final String CLOSE_ELEMENT_EMPTY = "/>";
    private static final String CLOSE_ELEMENT_START = "</";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String EQUALS = "=";
    private static final String QUOTE = "\"";
    private static final String SPACE = " ";
    private static final String WSDL = "WSDL";
    private static final String SERVICE = "Service";
    private static final String PORTTYPE = "PortType";
    private static final String BINDING = "Binding";
    private static final String OPERATION = "Operation";
    private static final String UNAME = "uname";
    private ArrayList m_complexTypes = new ArrayList();
    private Reader m_wsdlResultReader = null;
    private String m_contentType = "text/xml";

    private AGSWSDLResult() {
    }

    public AGSWSDLResult(XTSEnvironment env, String target, Definition def) throws XTSInstructionException {
        StringBuffer resultStartBuf = new StringBuffer(1000);
        resultStartBuf.append(OPEN_ELEMENT_START);
        resultStartBuf.append(WSDL);
        resultStartBuf.append(ELEMENT_END);
        try {
            Map sm = WSIFUtils.getAllItems((Definition)def, (String)SERVICE);
            Map portTypes = WSIFUtils.getAllItems((Definition)def, (String)PORTTYPE);
            ClassLoader cl = this.getClass().getClassLoader();
            WSIFWSDLLocatorImpl loc = new WSIFWSDLLocatorImpl(null, target, cl);
            try {
                Parser.getAllSchemaTypes((Definition)def, (List)this.m_complexTypes, (WSDLLocator)loc);
            }
            catch (WSIFException wSIFException) {
                // empty catch block
            }
            Iterator services = sm.values().iterator();
            while (services.hasNext()) {
                Object operationName = null;
                PortType portType = null;
                String portName = null;
                Service s = (Service)services.next();
                resultStartBuf.append(OPEN_ELEMENT_START);
                resultStartBuf.append(SERVICE);
                resultStartBuf.append(SPACE);
                resultStartBuf.append(NAME);
                resultStartBuf.append(EQUALS);
                resultStartBuf.append(QUOTE);
                resultStartBuf.append(s.getQName().getLocalPart());
                resultStartBuf.append(QUOTE);
                resultStartBuf.append(ELEMENT_END);
                for (Port p : s.getPorts().values()) {
                    Binding b = p.getBinding();
                    portName = p.getName();
                    portType = b.getPortType();
                    List l = b.getExtensibilityElements();
                    String portTypeName = portType.getQName().getLocalPart();
                    for (int x = 0; x < l.size(); ++x) {
                        resultStartBuf.append(OPEN_ELEMENT_START);
                        resultStartBuf.append(PORTTYPE);
                        resultStartBuf.append(SPACE);
                        resultStartBuf.append(NAME);
                        resultStartBuf.append(EQUALS);
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(portName);
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(SPACE);
                        resultStartBuf.append(TYPE);
                        resultStartBuf.append(EQUALS);
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(portTypeName);
                        resultStartBuf.append(QUOTE);
                        String y = l.get(x).getClass().getName();
                        resultStartBuf.append(SPACE);
                        resultStartBuf.append(BINDING);
                        resultStartBuf.append(EQUALS);
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(y.substring(y.lastIndexOf(".") + 1));
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(ELEMENT_END);
                        List operationList = portType.getOperations();
                        for (Operation op : operationList) {
                            Input opInput = op.getInput();
                            if (opInput == null) continue;
                            Message m = opInput.getMessage();
                            String name = op.getName();
                            List pm = m.getOrderedParts(null);
                            String uname = this.appendOperation(name, resultStartBuf, pm);
                            String searchIt = "Operation name=\"" + name + QUOTE;
                            resultStartBuf.insert(resultStartBuf.lastIndexOf(searchIt) + searchIt.length(), " uname=\"" + uname + QUOTE);
                        }
                        resultStartBuf.append(CLOSE_ELEMENT_START);
                        resultStartBuf.append(PORTTYPE);
                        resultStartBuf.append(ELEMENT_END);
                    }
                }
                resultStartBuf.append(CLOSE_ELEMENT_START);
                resultStartBuf.append(SERVICE);
                resultStartBuf.append(ELEMENT_END);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        resultStartBuf.append(CLOSE_ELEMENT_START);
        resultStartBuf.append(WSDL);
        resultStartBuf.append(ELEMENT_END);
        this.m_wsdlResultReader = new BufferedReader(new StringReader(resultStartBuf.toString()));
    }

    private String appendOperation(String name, StringBuffer resultStartBuf, List parts) throws XTSInstructionException {
        resultStartBuf.append(OPEN_ELEMENT_START);
        resultStartBuf.append(OPERATION);
        resultStartBuf.append(SPACE);
        resultStartBuf.append(NAME);
        resultStartBuf.append(EQUALS);
        resultStartBuf.append(QUOTE);
        resultStartBuf.append(name);
        resultStartBuf.append(QUOTE);
        resultStartBuf.append(ELEMENT_END);
        Iterator i = parts.iterator();
        StringBuffer oprNameList = new StringBuffer();
        while (i.hasNext()) {
            Part type = (Part)i.next();
            AGSComplexTypeHolder param = new AGSComplexTypeHolder(type, this.m_complexTypes);
            String docLitArgs = param.appendParameter(resultStartBuf);
            if (null == docLitArgs || docLitArgs.length() <= 1) continue;
            oprNameList.append(docLitArgs);
        }
        resultStartBuf.append(CLOSE_ELEMENT_START);
        resultStartBuf.append(OPERATION);
        resultStartBuf.append(ELEMENT_END);
        return name + "_[opr]_" + oprNameList.toString();
    }

    public XTSSource getResult() {
        return new XTSSource(this.m_wsdlResultReader);
    }

    public void release() throws XTSInstructionException {
    }

    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        try {
            ByteArrayIOStream bio = new ByteArrayIOStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bio, "UTF-8"));
            char[] buf = new char[4096];
            int bytesRead = this.m_wsdlResultReader.read(buf, 0, 4096);
            while (bytesRead != -1) {
                ((Writer)writer).write(buf, 0, bytesRead);
                bytesRead = this.m_wsdlResultReader.read(buf, 0, 4096);
            }
            ((Writer)writer).flush();
            bio.writeTo(out);
            this.m_wsdlResultReader = new BufferedReader(new InputStreamReader((InputStream)bio.convert(), "UTF-8"));
        }
        catch (IOException e) {
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, (Throwable)e);
        }
    }

    public boolean attachmentsSupported() {
        return false;
    }

    public int getSupportedOptionsBitMap() {
        return 7;
    }

    public boolean protocolHeaderSupported() {
        return false;
    }

    public InputStream getAttachmentInputStream() throws XTSInstructionException {
        return null;
    }

    public InternetHeaders getProtocolHeaders() throws XTSInstructionException {
        return null;
    }

    public ContentType getDefaultMimeType() throws XTSInstructionException {
        ContentType contentType = null;
        try {
            contentType = new ContentType(this.m_contentType);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return contentType;
    }

    public boolean statusHeaderSupported() {
        return false;
    }

    public InternetHeaders getStatusHeaders() throws XTSInstructionException {
        return null;
    }
}

