/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class AuroraConfiguration {
    public static final String PROPKEY_INI_LOCATION = "aurora.ini.location";
    public static final String DEFAULT_INI_LOCATION = "../configuration/aurora.ini";
    private static Properties properties = null;

    static File getPropertiesFile() throws FileNotFoundException {
        String auroraIniLocation = System.getProperty(PROPKEY_INI_LOCATION, DEFAULT_INI_LOCATION);
        File file = new File(auroraIniLocation);
        if (!file.exists()) {
            throw new FileNotFoundException("The Aurora configuration file is missing at: " + file.getAbsolutePath());
        }
        return file;
    }

    private static Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(AuroraConfiguration.getPropertiesFile()));
        try {
            properties.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    public static Properties getProperties() throws IOException {
        if (null == properties) {
            properties = AuroraConfiguration.loadProperties();
        }
        Properties result = new Properties();
        result.putAll((Map<?, ?>)properties);
        return result;
    }
}

