/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api;

import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.core.expert.config.ServiceEnumeration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfiguration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfigurationManager;
import java.util.Properties;

public final class QLSAPI {
    public static final String PROPKEY_QLS_CLASSNAME = "aurora.qls.class";
    private static final String DEFAULT_IMPL_CLASSNAME = "com.ibm.cognos.aurora.qls.query.QueryLogicalStorageImpl";
    public static final String PROPKEY_TEMP_DIR = "aurora.temp_dir";
    public static final String PROPKEY_DATA_DIR = "aurora.data_dir";
    public static final String PROPKEY_PROVIDERS = "aurora.qls.providers";
    public static final String PROPKEY_MONETDB_ENABLED = "aurora.qls.monetdb.enabled";
    public static final String PROPKEY_MONETDB_INTSTALL_DIR = "aurora.qls.monetdb.install_dir";
    public static final String PROPKEY_MONETDB_PORT = "aurora.qls.monetdb.port";
    public static final String PROPKEY_TM1_NGTM1API_LOCATION = "aurora.qls.tm1.ngtm1api.location";
    public static final String PROPKEY_TM1_SSL_CONFIGS_LOCATION = "ngtm1api_sslconfigs_path";
    public static final String PROPKEY_PMTA_ENABLED = "aurora.qls.pmta.enabled";
    public static final String PROPKEY_PMTA_EMBEDDED_TM1_DIR = "aurora.qls.pmta.embedded_tm1_dir";
    public static final String PROPKEY_PMTA_SERVER_OUT_OF_PROCESS = "aurora.qls.pmta.server_out_of_process";

    public static IQueryLogicalStorage getInstance(Properties props) {
        String qlsClassName = props.getProperty(PROPKEY_QLS_CLASSNAME);
        if (qlsClassName == null) {
            qlsClassName = DEFAULT_IMPL_CLASSNAME;
        }
        return QLSAPI.getInstance(qlsClassName, props);
    }

    public static IQueryLogicalStorage getInstance(String implClassName, Properties props) {
        IQueryLogicalStorage instance;
        if (null == props) {
            throw new IllegalArgumentException("props was null");
        }
        try {
            Class<?> implClass = Class.forName(implClassName);
            instance = (IQueryLogicalStorage)implClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to load implementation class.", ex);
        }
        XQEConfiguration xqeConfig = new XQEConfiguration(props);
        XQEConfigurationManager.getInstance().add(ServiceEnumeration.AURORA, xqeConfig);
        instance.initialize(props);
        return instance;
    }
}

