/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.asset;

import com.ibm.cognos.aurora.api.asset.IModelAssetFactory;
import com.ibm.cognos.aurora.api.asset.ModelAssetType;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class ModelAssetService {
    public static final String KEY_PREFIX = "ModelAssetFactoryImpl.";
    private static final ConcurrentHashMap<String, IModelAssetFactory> CACHE = new ConcurrentHashMap();

    public static IModelAssetFactory getFactory(ModelAssetType type) {
        return ModelAssetService.getFactory(type.getDefaultImpl());
    }

    public static IModelAssetFactory getFactory(ModelAssetType type, Properties config) {
        String key = KEY_PREFIX + type.name();
        String impl = config.getProperty(key, type.getDefaultImpl());
        return ModelAssetService.getFactory(impl);
    }

    private static IModelAssetFactory getFactory(String impl) {
        IModelAssetFactory factory = CACHE.get(impl);
        if (factory == null) {
            try {
                Class<?> cls = Class.forName(impl);
                if (cls != null) {
                    factory = (IModelAssetFactory)cls.newInstance();
                }
                CACHE.put(impl, factory);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return factory;
    }
}

