/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.exception;

import com.ibm.cognos.aurora.api.exception.IMessageKey;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Messages {
    private static final Pattern ERROR_MSG_PAT = Pattern.compile("^(([A-Z-]+[0-9]+)?)(.*)$");
    private static final int CODE_GROUP = 1;
    private static final int MESSAGE_GROUP = 3;

    private Messages() {
    }

    public static String getMessage(IMessageKey.Param0 key, Locale locale) {
        if (key == null) {
            return null;
        }
        return Messages.getMessage(key, locale, new Object[0]);
    }

    public static String getMessage(IMessageKey.Param1 key, Locale locale, String arg1) {
        if (key == null) {
            return null;
        }
        return Messages.getMessage((IMessageKey)key, locale, new Object[]{arg1});
    }

    public static String getMessage(IMessageKey.Param2 key, Locale locale, String arg1, String arg2) {
        if (key == null) {
            return null;
        }
        return Messages.getMessage(key, locale, new Object[]{arg1, arg2});
    }

    public static String getMessage(IMessageKey.Param3 key, Locale locale, String arg1, String arg2, String arg3) {
        if (key == null) {
            return null;
        }
        return Messages.getMessage(key, locale, new Object[]{arg1, arg2, arg3});
    }

    public static String getMessage(IMessageKey.Param4 key, Locale locale, String arg1, String arg2, String arg3, String arg4) {
        if (key == null) {
            return null;
        }
        return Messages.getMessage(key, locale, new Object[]{arg1, arg2, arg3, arg4});
    }

    public static String getMessage(IMessageKey key, Locale locale, Object[] arguments) {
        String localizedMessage;
        Locale loc;
        if (key == null) {
            return null;
        }
        String strKey = key.toString();
        if (key.getBundleKeyPrefix() != null && key.getBundleKeyPrefix().length() > 0) {
            strKey = key.getBundleKeyPrefix() + "_" + strKey;
        }
        if ((loc = locale) == null) {
            loc = Locale.getDefault();
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(key.getBundleFileName(), loc);
            localizedMessage = bundle.getString(strKey);
        }
        catch (MissingResourceException m) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(key.getBundleFileName(), Locale.ENGLISH);
                localizedMessage = bundle.getString(strKey);
            }
            catch (MissingResourceException mre) {
                return mre.getMessage();
            }
        }
        if (arguments == null) {
            return localizedMessage;
        }
        return MessageFormat.format(localizedMessage, arguments);
    }

    public static String getErrorCode(String msg) {
        Matcher matcher = ERROR_MSG_PAT.matcher(msg);
        if (!matcher.matches()) {
            return "";
        }
        return matcher.group(1);
    }

    public static String getErrorMessage(String msg) {
        Matcher matcher = ERROR_MSG_PAT.matcher(msg);
        if (!matcher.matches()) {
            return "";
        }
        return matcher.group(3);
    }
}

