/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.datatype;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.BooleanType;
import com.ibm.cognos.aurora.api.model.datatype.DateType;
import com.ibm.cognos.aurora.api.model.datatype.DecimalType;
import com.ibm.cognos.aurora.api.model.datatype.DoubleType;
import com.ibm.cognos.aurora.api.model.datatype.FloatType;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.datatype.IntegerType;
import com.ibm.cognos.aurora.api.model.datatype.LongType;
import com.ibm.cognos.aurora.api.model.datatype.ObjectType;
import com.ibm.cognos.aurora.api.model.datatype.StringType;
import com.ibm.cognos.aurora.api.model.datatype.TimeType;
import com.ibm.cognos.aurora.api.model.datatype.TimestampType;
import com.ibm.cognos.aurora.api.model.datatype.UnknownType;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.dom4j.Element;

public final class DataTypes {
    private static final int INT_MAX_CHARS = Integer.toString(Integer.MIN_VALUE).length();
    private static final int LONG_MAX_CHARS = Long.toString(Long.MIN_VALUE).length();
    private static final int FLOAT_MAX_CHARS = Float.toString(-3.4028235E38f).length();
    private static final int DOUBLE_MAX_CHARS = Double.toString(-1.7976931348623157E308).length();
    private static final int DATE_MAX_CHARS = 32;
    private static final int TIME_MAX_CHARS = 32;
    private static final int TIMESTAMP_MAX_CHARS = 32;
    private static final int BOOLEAN_MAX_CHARS = 5;
    private static final UnknownType UNKNOWN_TYPE = new UnknownType();
    private static final BooleanType BOOLEAN_TYPE = new BooleanType();
    private static final IntegerType INTEGER_TYPE = new IntegerType();
    private static final LongType LONG_TYPE = new LongType();
    private static final FloatType FLOAT_TYPE = new FloatType();
    private static final DecimalType DECIMAL_TYPE = new DecimalType();
    private static final DoubleType DOUBLE_TYPE = new DoubleType();
    private static final DateType DATE_TYPE = new DateType();
    private static final TimeType TIME_TYPE = new TimeType();
    private static final TimestampType TIMESTAMP_TYPE = new TimestampType();
    private static final ObjectType OBJECT_TYPE = new ObjectType();

    public static UnknownType getUnknownType() {
        return UNKNOWN_TYPE;
    }

    public static ObjectType getObjectType() {
        return OBJECT_TYPE;
    }

    public static StringType getStringType(int maxLength) {
        return new StringType(maxLength);
    }

    public static BooleanType getBooleanType() {
        return BOOLEAN_TYPE;
    }

    public static IntegerType getIntegerType() {
        return INTEGER_TYPE;
    }

    public static LongType getLongType() {
        return LONG_TYPE;
    }

    public static FloatType getFloatType() {
        return FLOAT_TYPE;
    }

    public static DoubleType getDoubleType() {
        return DOUBLE_TYPE;
    }

    public static DecimalType getDecimalType() {
        return DECIMAL_TYPE;
    }

    public static DecimalType getDecimalType(int precision) {
        return new DecimalType(precision);
    }

    public static DecimalType getDecimalType(int precision, int scale) {
        return new DecimalType(precision, scale);
    }

    public static DateType getDateType() {
        return DATE_TYPE;
    }

    public static TimeType getTimeType() {
        return TIME_TYPE;
    }

    public static TimestampType getTimestampType() {
        return TIMESTAMP_TYPE;
    }

    public static IDataType fromBaseType(BaseDataType baseType) {
        switch (baseType) {
            case BOOLEAN: {
                return DataTypes.getBooleanType();
            }
            case DATE: {
                return DataTypes.getDateType();
            }
            case TIME: {
                return DataTypes.getTimeType();
            }
            case TIMESTAMP: {
                return DataTypes.getTimestampType();
            }
            case DOUBLE: {
                return DataTypes.getDoubleType();
            }
            case DECIMAL: {
                return DataTypes.getDecimalType();
            }
            case FLOAT: {
                return DataTypes.getFloatType();
            }
            case INTEGER: {
                return DataTypes.getIntegerType();
            }
            case LONG: {
                return DataTypes.getLongType();
            }
            case STRING: {
                return DataTypes.getStringType(Integer.MAX_VALUE);
            }
            case UNKNOWN: {
                return DataTypes.getUnknownType();
            }
            case OBJECT: {
                return DataTypes.getObjectType();
            }
        }
        throw new IllegalArgumentException("Unsupported base type:" + baseType.toString());
    }

    public static IDataType fromXSDType(String xsdType, int precision, int scale) {
        if (xsdType.endsWith("boolean")) {
            return DataTypes.getBooleanType();
        }
        if (xsdType.endsWith("string")) {
            return DataTypes.getStringType(precision);
        }
        if (xsdType.endsWith("integer") || xsdType.endsWith("int")) {
            return DataTypes.getIntegerType();
        }
        if (xsdType.endsWith("short")) {
            return DataTypes.getIntegerType();
        }
        if (xsdType.endsWith("long")) {
            return DataTypes.getLongType();
        }
        if (xsdType.endsWith("date")) {
            return DataTypes.getDateType();
        }
        if (xsdType.endsWith("time")) {
            return DataTypes.getTimeType();
        }
        if (xsdType.endsWith("dateTime")) {
            return DataTypes.getTimestampType();
        }
        if (xsdType.endsWith("double")) {
            return DataTypes.getDoubleType();
        }
        if (xsdType.endsWith("decimal")) {
            return DataTypes.getDecimalType(precision, scale);
        }
        throw new IllegalArgumentException("Unsupported XSD type: " + xsdType);
    }

    public static IDataType fromStringType(String strType) {
        if (strType.equals("boolean")) {
            return DataTypes.getBooleanType();
        }
        if (strType.equals("date")) {
            return DataTypes.getDateType();
        }
        if (strType.equals("time")) {
            return DataTypes.getTimeType();
        }
        if (strType.equals("timestamp")) {
            return DataTypes.getTimestampType();
        }
        if (strType.startsWith("decimal")) {
            int idxComma = strType.indexOf(",");
            int precision = Integer.parseInt(strType.substring(8, idxComma).trim());
            int scale = Integer.parseInt(strType.substring(idxComma + 1, strType.length() - 1).trim());
            return DataTypes.getDecimalType(precision, scale);
        }
        if (strType.equals("double")) {
            return DataTypes.getDoubleType();
        }
        if (strType.equals("float")) {
            return DataTypes.getFloatType();
        }
        if (strType.equals("integer")) {
            return DataTypes.getIntegerType();
        }
        if (strType.equals("long")) {
            return DataTypes.getLongType();
        }
        if (strType.equals("object")) {
            return DataTypes.getObjectType();
        }
        if (strType.startsWith("string")) {
            int precision = Integer.parseInt(strType.substring(7, strType.length() - 1).trim());
            return DataTypes.getStringType(precision);
        }
        if (strType.equals("unknown")) {
            return DataTypes.getUnknownType();
        }
        throw new IllegalArgumentException("Unsupported string type: " + strType);
    }

    public static void encodeBinary(DataOutput out, EncoderContext ctx, IDataType dataType) throws IOException {
        if (null == dataType) {
            dataType = DataTypes.getUnknownType();
        }
        BaseDataType baseType = dataType.getBaseType();
        out.writeByte((byte)baseType.ordinal());
        dataType.encodeBinary(out, ctx);
    }

    public static IDataType decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        byte baseTypeOrdinal = in.readByte();
        BaseDataType baseType = BaseDataType.values()[baseTypeOrdinal];
        IDataType dataType = DataTypes.fromBaseType(baseType);
        dataType.decodeBinary(in, ctx);
        return dataType;
    }

    public static void encodeElement(Element elem, EncoderContext ctx, IDataType dataType) {
        if (null == dataType) {
            dataType = DataTypes.getUnknownType();
        }
        elem.addAttribute("baseType", dataType.getBaseType().name());
        dataType.encodeElement(elem, ctx);
    }

    public static IDataType decodeElement(Element elem, EncoderContext ctx) {
        BaseDataType baseType = BaseDataType.valueOf(elem.attributeValue("baseType"));
        IDataType dataType = DataTypes.fromBaseType(baseType);
        dataType.decodeElement(elem, ctx);
        return dataType;
    }

    public static IDataType widestCompatibleType(IDataType left, IDataType right) {
        int rightLength;
        int leftLength;
        int leftRank = DataTypes.getRank(left);
        int rightRank = DataTypes.getRank(right);
        IDataType result = null;
        result = leftRank >= rightRank ? (left.isString() || left.isTemporal() ? ((leftLength = DataTypes.getStringLength(left)) < (rightLength = DataTypes.getStringLength(right)) ? DataTypes.getStringType(rightLength) : left) : left) : (right.isString() || right.isTemporal() ? ((leftLength = DataTypes.getStringLength(left)) > (rightLength = DataTypes.getStringLength(right)) ? DataTypes.getStringType(leftLength) : DataTypes.getStringType(rightLength)) : right);
        return result;
    }

    private static int getRank(IDataType dataType) {
        switch (dataType.getBaseType()) {
            case UNKNOWN: 
            case OBJECT: {
                return 0;
            }
            case BOOLEAN: {
                return 1;
            }
            case INTEGER: {
                return 2;
            }
            case LONG: {
                return 3;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 5;
            }
            case DECIMAL: {
                return 6;
            }
            case TIME: {
                return 7;
            }
            case DATE: {
                return 8;
            }
            case TIMESTAMP: {
                return 9;
            }
            case STRING: {
                return 10;
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType.toString());
    }

    public static int getStringLength(IDataType dataType) {
        switch (dataType.getBaseType()) {
            case BOOLEAN: {
                return 5;
            }
            case DOUBLE: {
                return DOUBLE_MAX_CHARS;
            }
            case DECIMAL: {
                return ((DecimalType)dataType).getPrecision() + 2;
            }
            case FLOAT: {
                return FLOAT_MAX_CHARS;
            }
            case INTEGER: {
                return INT_MAX_CHARS;
            }
            case LONG: {
                return LONG_MAX_CHARS;
            }
            case DATE: {
                return 32;
            }
            case TIME: {
                return 32;
            }
            case TIMESTAMP: {
                return 32;
            }
            case STRING: {
                return ((StringType)dataType).getMaxLength();
            }
            case UNKNOWN: 
            case OBJECT: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType.toString());
    }

    private DataTypes() {
    }
}

