/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueBase;
import com.ibm.cognos.aurora.api.model.value.ValueStatus;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;

public class BooleanValue
extends ValueBase {
    private boolean mValue;

    public BooleanValue() {
        this.setStatus(ValueStatus.NULL);
    }

    public BooleanValue(boolean value, ValueStatus status) {
        this.set(value, status);
    }

    public BooleanValue(boolean value) {
        this.set(value);
    }

    @Override
    public IDataType getType() {
        return DataTypes.getBooleanType();
    }

    public void set(boolean value, ValueStatus status) {
        this.mValue = value;
        this.setStatus(status);
    }

    public void set(boolean value) {
        this.set(value, ValueStatus.OK);
    }

    public void set(Boolean value) {
        if (null == value) {
            this.set(false, ValueStatus.NULL);
        } else {
            this.set(value, ValueStatus.OK);
        }
    }

    @Override
    public Object objectValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.mValue;
    }

    @Override
    public Number numberValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.intValue();
    }

    @Override
    public String stringValue() {
        if (!this.isOK()) {
            return null;
        }
        return Boolean.toString(this.mValue);
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (!this.isOK()) {
            return null;
        }
        return new BigDecimal(this.intValue());
    }

    @Override
    public int intValue() {
        if (!this.isOK()) {
            return 0;
        }
        if (this.mValue) {
            return 1;
        }
        return 0;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public Date dateValue() {
        if (!this.isOK()) {
            return null;
        }
        return DELINQUENT_DATE;
    }

    @Override
    public boolean booleanValue() {
        if (!this.isOK()) {
            return false;
        }
        return this.mValue;
    }

    public int hashCode() {
        return this.getStatus().hashCode() + this.intValue();
    }

    @Override
    public int compareTo(IValue other) {
        int rightValue;
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        if (other.getType().getBaseType() != BaseDataType.BOOLEAN) {
            return BooleanValue.compareValue(this, other);
        }
        int c = BooleanValue.compareStatus(this.getStatus(), other.getStatus());
        if (0 != c) {
            return c;
        }
        int leftValue = this.intValue();
        if (leftValue < (rightValue = other.intValue())) {
            return -1;
        }
        if (leftValue > rightValue) {
            return 1;
        }
        return 0;
    }

    @Override
    public void assignFrom(IValue value) {
        if (null == value) {
            this.set(false, ValueStatus.NULL);
        } else {
            this.set(value.booleanValue(), value.getStatus());
        }
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set(false, ValueStatus.NULL);
        } else {
            this.set(Boolean.parseBoolean(value), ValueStatus.OK);
        }
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        super.encodeBinary(out, ctx);
        if (this.getStatus() == ValueStatus.OK) {
            out.writeBoolean(this.mValue);
        }
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        super.decodeBinary(in, ctx);
        this.mValue = this.getStatus() == ValueStatus.OK ? in.readBoolean() : false;
    }
}

