/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;
import com.ibm.cognos.aurora.api.model.value.ValueBase;
import com.ibm.cognos.aurora.api.model.value.ValueStatus;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;

public abstract class DateTimeValue
extends ValueBase {
    public static final TimeZone TIMEZONE_DEFAULT = TimeZone.getDefault();
    public static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone((String)"UTC");
    protected static final ULocale EN_US = new ULocale("en_US");
    public static final int NANOSECONDS_PER_MILLISECOND = 1000000;
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int HOURS_PER_DAY = 24;
    public static final int DAYS_PER_WEEK = 7;
    public static final int MILLISECONDS_PER_MINUTE = 60000;
    public static final int MILLISECONDS_PER_HOUR = 3600000;
    public static final int MILLISECONDS_PER_DAY = 86400000;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;
    public static final int MINUTES_PER_DAY = 1440;
    public static final int MONTHS_PER_YEAR = 12;
    public static final int NUMBER_OF_DAYS_IN_FIRST_ISO_WEEK = 4;
    public static final int ISO_FIRST_DAY_OF_WEEK = 2;
    public static final int ISO_DOW_CONVERSION_FACTOR = 5;
    protected static final int PRECISION = 9;
    private static final String GMT = "GMT";
    public static final String HYPHEN = "-";
    public static final String COLON = ":";
    public static final String RX_DATE = "[0-9]{1,4}+-[0-9]{1,2}+-[0-9]{1,2}+";
    public static final String RX_TIME = "[0-9]{1,2}+:[0-9]{1,2}+:[0-9]{1,2}+(\\.[0-9]{1,9}+)?";
    public static final String RX_TIMEZONE = "(\\+|-)[0-9]{1,2}+(:[0-9]{1,2}+)?";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    static final String[] ZEROS = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000"};
    private static final GregorianCalendar ISO_8601_CALENDAR = new GregorianCalendar();
    private static final ConcurrentHashMap<Integer, TimeZone> TIMEZONE_BY_OFFSET_CACHE;
    private final GregorianCalendar mCal;

    public static GregorianCalendar getISO8601Calendar() {
        return (GregorianCalendar)ISO_8601_CALENDAR.clone();
    }

    public static GregorianCalendar getISO8601Calendar(TimeZone tz) {
        GregorianCalendar cal = (GregorianCalendar)ISO_8601_CALENDAR.clone();
        cal.setTimeZone(tz);
        return cal;
    }

    public DateTimeValue() {
        this.mCal = DateTimeValue.getISO8601Calendar();
        this.setStatus(ValueStatus.NULL);
    }

    public DateTimeValue(TimeZone tz) {
        this.mCal = DateTimeValue.getISO8601Calendar(tz);
        this.setStatus(ValueStatus.NULL);
    }

    public DateTimeValue(Date dt) {
        this.mCal = DateTimeValue.getISO8601Calendar();
        this.set(dt);
    }

    public DateTimeValue(Date dt, TimeZone tz) {
        this.mCal = DateTimeValue.getISO8601Calendar();
        this.set(dt, tz);
    }

    public DateTimeValue(Calendar cal) {
        this.mCal = DateTimeValue.getISO8601Calendar();
        this.set(cal);
    }

    public Calendar getCalendar() {
        return this.mCal;
    }

    public int getYear() {
        return this.mCal.get(1);
    }

    public int getMonth() {
        return this.mCal.get(2) + 1;
    }

    public int getDay() {
        return this.mCal.get(5);
    }

    public int getHour() {
        return this.mCal.get(11);
    }

    public int getMinute() {
        return this.mCal.get(12);
    }

    public int getSecond() {
        return this.mCal.get(13);
    }

    public int getMillisecond() {
        return this.mCal.get(14);
    }

    public long getTimeInMillis() {
        return this.mCal.getTimeInMillis();
    }

    public TimeZone getTimeZone() {
        return this.mCal.getTimeZone();
    }

    public boolean useDaylight() {
        return this.mCal.getTimeZone().useDaylightTime();
    }

    public int getTimeZoneHour() {
        int dstOffset = 0;
        if (this.useDaylight()) {
            dstOffset = this.mCal.get(16);
        }
        return (this.mCal.get(15) + dstOffset) / 3600000;
    }

    public int getTimeZoneMinute() {
        return this.mCal.get(15) % 3600000 / 60000;
    }

    public int getDSTOffset() {
        return this.mCal.get(16);
    }

    public int weekOfYear() {
        return this.mCal.get(3);
    }

    public int dayOfYear() {
        return this.mCal.get(6);
    }

    public int dayOfWeek() {
        return (this.mCal.get(7) + 5) % 7 + 1;
    }

    @Override
    public Object objectValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.dateValue();
    }

    @Override
    public Number numberValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.longValue();
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (!this.isOK()) {
            return null;
        }
        return new BigDecimal(this.longValue());
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        if (!this.isOK()) {
            return 0L;
        }
        return this.mCal.getTimeInMillis();
    }

    @Override
    public Date dateValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.mCal.getTime();
    }

    @Override
    public boolean booleanValue() {
        return 0L != this.longValue();
    }

    protected final void clearTimeFields() {
        this.mCal.clear(11);
        this.mCal.clear(12);
        this.mCal.clear(13);
        this.mCal.clear(14);
        this.mCal.clear(16);
        this.mCal.clear(15);
    }

    @Override
    public abstract void assignFrom(String var1);

    public final void set(Date dt) {
        if (null == dt) {
            this.set(null, null, ValueStatus.NULL);
        } else {
            this.set(dt, null, ValueStatus.OK);
        }
    }

    public final void set(Date dt, TimeZone tz) {
        if (null == dt) {
            this.set(null, tz, ValueStatus.NULL);
        } else {
            this.set(dt, tz, ValueStatus.OK);
        }
    }

    public final void set(Date dt, ValueStatus status) {
        this.set(dt, null, status);
    }

    public void set(Date dt, TimeZone tz, ValueStatus status) {
        this.setStatus(status);
        this.mCal.clear();
        if (null != tz) {
            this.mCal.setTimeZone(tz);
        }
        if (status == ValueStatus.OK) {
            this.mCal.setTimeInMillis(dt.getTime());
            this.mCal.get(1);
        }
    }

    public final void set(Calendar cal) {
        if (null == cal) {
            this.set((Calendar)null, ValueStatus.NULL);
        } else {
            this.set(cal, ValueStatus.OK);
        }
    }

    public final void set(Calendar cal, ValueStatus status) {
        if (ValueStatus.OK != status) {
            this.set(null, null, status);
        } else {
            this.set(cal.getTime(), cal.getTimeZone(), status);
        }
    }

    public void setYear(int year) {
        this.mCal.set(1, year);
    }

    public void setMonth(int month) {
        this.mCal.set(2, month - 1);
    }

    public void setDay(int day) {
        this.mCal.set(5, day);
    }

    public void setHour(int hour) {
        this.mCal.set(11, hour);
    }

    public void setMinute(int minute) {
        this.mCal.set(12, minute);
    }

    public void setSecond(int second) {
        this.mCal.set(13, second);
    }

    public void setMillisecond(int millisecond) {
        this.mCal.set(14, millisecond);
    }

    public void setTimeZone(TimeZone tz) {
        this.mCal.setTimeZone(tz);
    }

    public void addYears(int nYears) {
        this.mCal.add(1, nYears);
    }

    public void addMonths(int nMonths) {
        this.mCal.add(2, nMonths);
    }

    public void addDays(int nDays) {
        this.mCal.add(5, nDays);
    }

    public void addHours(int nHours) {
        this.mCal.add(11, nHours);
    }

    public void addMinutes(int nMinutes) {
        this.mCal.add(12, nMinutes);
    }

    public void addSeconds(int nSeconds) {
        this.mCal.add(13, nSeconds);
    }

    public void addMilliseconds(int nMillieconds) {
        this.mCal.add(14, nMillieconds);
    }

    public String convertTimeZoneToString() {
        StringBuilder b = new StringBuilder();
        int hour = this.getTimeZoneHour();
        int minute = Math.abs(this.getTimeZoneMinute());
        if (hour < 0) {
            hour = -hour;
            b.append(HYPHEN);
        } else {
            b.append("+");
        }
        DecimalFormat f = new DecimalFormat(ZEROS[2]);
        b.append(f.format((long)hour) + COLON + f.format((long)minute));
        return b.toString();
    }

    @Override
    public final void assignFrom(IValue value) {
        if (null == value || ValueStatus.NULL == value.getStatus()) {
            this.set((Date)null, ValueStatus.NULL);
        } else if (value instanceof DateTimeValue) {
            this.set(((DateTimeValue)value).getCalendar(), value.getStatus());
        } else if (value instanceof StringValue) {
            this.assignFrom(value.stringValue());
        } else {
            this.set(value.dateValue(), value.getStatus());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(IValue other) {
        long rightValue;
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        int c = DateTimeValue.compareStatus(this.getStatus(), other.getStatus());
        if (0 != c) {
            return c;
        }
        long leftValue = this.getTimeInMillis();
        if (other.getType().isTemporal()) {
            rightValue = ((DateTimeValue)other).getTimeInMillis();
        } else if (other.getType().isNumeric()) {
            rightValue = other.longValue();
        } else {
            if (!other.getType().isString()) return 1;
            DateTimeValue v = (DateTimeValue)this.clone();
            v.assignFrom(other.stringValue());
            if (!v.isOK()) return 1;
            rightValue = v.getTimeInMillis();
        }
        if (leftValue < rightValue) {
            return -1;
        }
        if (leftValue <= rightValue) return 0;
        return 1;
    }

    public int hashCode() {
        if (this.isNull()) {
            return Integer.MIN_VALUE;
        }
        if (this.isError()) {
            return Integer.MAX_VALUE;
        }
        long millis = this.getTimeInMillis();
        return (int)(millis ^ millis >>> 32);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        super.encodeBinary(out, ctx);
        if (this.getStatus() == ValueStatus.OK) {
            out.writeInt(this.getTimeZone().getRawOffset());
            out.writeLong(this.getTimeInMillis());
        }
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        super.decodeBinary(in, ctx);
        this.mCal.clear();
        if (this.getStatus() == ValueStatus.OK) {
            this.setTimeZone(DateTimeValue.getTimeZoneFromRawOffset(in.readInt()));
            this.mCal.setTimeInMillis(in.readLong());
        }
    }

    public static TimeZone getTimeZoneFromRawOffset(int rawOffset) {
        String[] ids;
        String timeZoneID;
        TimeZone old;
        if (rawOffset == 0) {
            return TIMEZONE_UTC;
        }
        Integer rawOffsetObj = rawOffset;
        TimeZone tz = TIMEZONE_BY_OFFSET_CACHE.get(rawOffsetObj);
        if (null == tz && null != (old = TIMEZONE_BY_OFFSET_CACHE.putIfAbsent(rawOffsetObj, tz = new SimpleTimeZone(rawOffset, timeZoneID = (ids = TimeZone.getAvailableIDs((int)rawOffset)).length == 0 ? DateTimeValue.createCustomTimeZoneID(rawOffset) : ids[0])))) {
            tz = old;
        }
        return tz;
    }

    public static String createCustomTimeZoneID(int offset) {
        int sign = 1;
        int effectiveOffset = offset;
        if (offset < 0) {
            sign = -1;
            effectiveOffset = -offset;
        }
        int tzHour = effectiveOffset / 3600000;
        int tzMinute = effectiveOffset % 3600000 / 60000;
        return DateTimeValue.createCustomTimeZoneID(sign, tzHour, tzMinute);
    }

    public static String createCustomTimeZoneID(int sign, int tzHour, int tzMinute) {
        StringBuilder sb = new StringBuilder();
        sb.append(GMT);
        if (sign > 0) {
            sb.append("+");
        } else {
            sb.append(HYPHEN);
        }
        sb.append(tzHour);
        sb.append(COLON);
        sb.append(tzMinute);
        return sb.toString();
    }

    static {
        ISO_8601_CALENDAR.setFirstDayOfWeek(2);
        ISO_8601_CALENDAR.setMinimalDaysInFirstWeek(4);
        ISO_8601_CALENDAR.clear();
        TIMEZONE_BY_OFFSET_CACHE = new ConcurrentHashMap();
    }
}

