/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.datatype.StringType;
import com.ibm.cognos.aurora.api.model.value.DateTimeValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueBase;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.model.value.ValueStatus;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.icu.text.DecimalFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class StringValue
extends ValueBase {
    private StringType mType;
    private String mValue;

    public StringValue() {
        this.mType = DataTypes.getStringType(1);
        this.setStatus(ValueStatus.NULL);
    }

    public StringValue(StringType type) {
        this.mType = type;
        this.setStatus(ValueStatus.NULL);
    }

    public StringValue(String value, ValueStatus status) {
        this.mValue = value;
        this.mType = null != value ? DataTypes.getStringType(Math.max(1, value.length())) : DataTypes.getStringType(1);
        this.setStatus(status);
    }

    public StringValue(String value) {
        this.mValue = value;
        if (null != value) {
            this.mType = DataTypes.getStringType(Math.max(1, value.length()));
            this.setStatus(ValueStatus.OK);
        } else {
            this.mType = DataTypes.getStringType(1);
            this.setStatus(ValueStatus.NULL);
        }
    }

    public StringValue(StringType type, String value, ValueStatus status) {
        this.mValue = value;
        this.mType = type;
        this.setStatus(status);
    }

    public StringValue(StringType type, String value) {
        this.mValue = value;
        this.mType = type;
        if (null == value) {
            this.setStatus(ValueStatus.NULL);
        } else {
            this.setStatus(ValueStatus.OK);
        }
    }

    @Override
    public IDataType getType() {
        return this.mType;
    }

    public void set(String value, ValueStatus status) {
        if (null != value && value.length() > this.mType.getMaxLength()) {
            this.mType = this.mType.withMaxLength(Math.max(1, value.length()));
        }
        this.mValue = value;
        this.setStatus(status);
    }

    public void set(String value) {
        if (null == value) {
            this.set(null, ValueStatus.NULL);
        } else {
            this.set(value, ValueStatus.OK);
        }
    }

    @Override
    public Object objectValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.mValue;
    }

    @Override
    public Number numberValue() {
        if (!this.isOK() || null == this.mValue) {
            return null;
        }
        try {
            return DecimalFormat.getInstance().parse(this.mValue);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    @Override
    public String stringValue() {
        if (!this.isOK()) {
            return null;
        }
        if (null == this.mValue) {
            return "null";
        }
        return this.mValue;
    }

    @Override
    public float floatValue() {
        if (!this.isOK() || null == this.mValue) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(this.mValue);
        }
        catch (Exception ex) {
            return 0.0f;
        }
    }

    @Override
    public double doubleValue() {
        if (!this.isOK() || null == this.mValue) {
            return 0.0;
        }
        try {
            return Double.parseDouble(this.mValue);
        }
        catch (Exception ex) {
            return 0.0;
        }
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (!this.isOK()) {
            return null;
        }
        if (null == this.mValue) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(this.mValue);
        }
        catch (Exception ex) {
            return BigDecimal.ZERO;
        }
    }

    @Override
    public int intValue() {
        if (!this.isOK() || null == this.mValue) {
            return 0;
        }
        try {
            return Integer.parseInt(this.mValue);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public long longValue() {
        if (!this.isOK() || null == this.mValue) {
            return 0L;
        }
        try {
            return Long.parseLong(this.mValue);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    @Override
    public Date dateValue() {
        if (!this.isOK()) {
            return null;
        }
        if (null == this.mValue) {
            return DELINQUENT_DATE;
        }
        DateTimeValue v = ValueFactory.createTimestamp();
        v.assignFrom(this.mValue);
        if (v.isOK()) {
            return v.dateValue();
        }
        v = ValueFactory.createDate();
        v.assignFrom(this.mValue);
        if (v.isOK()) {
            return v.dateValue();
        }
        v = ValueFactory.createTime();
        v.assignFrom(this.mValue);
        if (v.isOK()) {
            return v.dateValue();
        }
        return DELINQUENT_DATE;
    }

    @Override
    public boolean booleanValue() {
        if (!this.isOK() || null == this.mValue) {
            return false;
        }
        String temp = this.mValue.toLowerCase();
        return "true".equals(temp) || "yes".equals(temp);
    }

    public int hashCode() {
        if (this.mValue == null) {
            return this.getStatus().hashCode();
        }
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getStatus());
        builder.append((Object)this.mValue);
        return builder.toHashCode();
    }

    @Override
    public int compareTo(IValue other) {
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        if (other.getType().getBaseType() != BaseDataType.STRING) {
            return StringValue.compareValue(this, other);
        }
        int c = StringValue.compareStatus(this.getStatus(), other.getStatus());
        if (0 != c) {
            return c;
        }
        String leftValue = this.stringValue();
        String rightValue = other.stringValue();
        if (null == leftValue) {
            if (null == rightValue) {
                return 0;
            }
            return -1;
        }
        if (null == rightValue) {
            return 1;
        }
        return leftValue.compareTo(rightValue);
    }

    @Override
    public void assignFrom(IValue value) {
        if (null == value || ValueStatus.NULL == value.getStatus()) {
            this.set(null, ValueStatus.NULL);
        } else {
            this.set(value.stringValue(), value.getStatus());
        }
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set(null, ValueStatus.NULL);
        } else {
            this.set(value, ValueStatus.OK);
        }
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        super.encodeBinary(out, ctx);
        if (this.getStatus() == ValueStatus.OK) {
            EncodeUtil.writeString((DataOutput)out, (String)this.mValue);
        }
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        super.decodeBinary(in, ctx);
        if (this.getStatus() == ValueStatus.OK) {
            this.mValue = EncodeUtil.readString((DataInput)in);
        }
    }
}

