/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value;

import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.BooleanValue;
import com.ibm.cognos.aurora.api.model.value.DateValue;
import com.ibm.cognos.aurora.api.model.value.DecimalValue;
import com.ibm.cognos.aurora.api.model.value.DoubleValue;
import com.ibm.cognos.aurora.api.model.value.FloatValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.IntegerValue;
import com.ibm.cognos.aurora.api.model.value.LongValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;
import com.ibm.cognos.aurora.api.model.value.TimeValue;
import com.ibm.cognos.aurora.api.model.value.TimestampValue;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.dom4j.Element;

public final class ValueFactory {
    public static StringValue createString(int maxLength) {
        return new StringValue(DataTypes.getStringType(maxLength));
    }

    public static StringValue createString(String value) {
        return new StringValue(value);
    }

    public static IntegerValue createInteger() {
        return new IntegerValue();
    }

    public static IntegerValue createInteger(int value) {
        return new IntegerValue(value);
    }

    public static IntegerValue createInteger(Integer value) {
        if (null == value) {
            return new IntegerValue();
        }
        return new IntegerValue(value);
    }

    public static LongValue createLong() {
        return new LongValue();
    }

    public static LongValue createLong(long value) {
        return new LongValue(value);
    }

    public static LongValue createLong(Long value) {
        if (null == value) {
            return new LongValue();
        }
        return new LongValue(value);
    }

    public static FloatValue createFloat() {
        return new FloatValue();
    }

    public static FloatValue createFloat(float value) {
        return new FloatValue(value);
    }

    public static FloatValue createFloat(Float value) {
        if (null == value) {
            return new FloatValue();
        }
        return new FloatValue(value.floatValue());
    }

    public static DoubleValue createDouble() {
        return new DoubleValue();
    }

    public static DoubleValue createDouble(double value) {
        return new DoubleValue(value);
    }

    public static DoubleValue createDouble(Double value) {
        if (null == value) {
            return new DoubleValue();
        }
        return new DoubleValue(value);
    }

    public static DecimalValue createDecimal() {
        return new DecimalValue();
    }

    public static DecimalValue createDecimal(int precision, int scale) {
        return new DecimalValue(DataTypes.getDecimalType(precision, scale));
    }

    public static DecimalValue createDecimal(BigDecimal value) {
        return new DecimalValue(value);
    }

    public static DecimalValue createDecimal(BigDecimal value, int precision, int scale) {
        return new DecimalValue(DataTypes.getDecimalType(precision, scale), value);
    }

    public static BooleanValue createBoolean() {
        return new BooleanValue();
    }

    public static BooleanValue createBoolean(boolean value) {
        return new BooleanValue(value);
    }

    public static BooleanValue createBoolean(Boolean value) {
        if (null == value) {
            return new BooleanValue();
        }
        return new BooleanValue(value);
    }

    public static DateValue createDate() {
        return new DateValue();
    }

    public static DateValue createDate(Date value) {
        return new DateValue(value);
    }

    public static DateValue createDate(Date value, TimeZone tz) {
        return new DateValue(value, tz);
    }

    public static DateValue createDate(Calendar cal) {
        return new DateValue(cal);
    }

    public static TimeValue createTime() {
        return new TimeValue();
    }

    public static TimeValue createTime(Date value) {
        return new TimeValue(value);
    }

    public static TimeValue createTime(Date value, TimeZone tz) {
        return new TimeValue(value, tz);
    }

    public static TimeValue createTime(Calendar cal) {
        return new TimeValue(cal);
    }

    public static TimestampValue createTimestamp() {
        return new TimestampValue();
    }

    public static TimestampValue createTimestamp(Date value) {
        return new TimestampValue(value);
    }

    public static TimestampValue createTimestamp(Date value, TimeZone tz) {
        return new TimestampValue(value, tz);
    }

    public static TimestampValue createTimestamp(Calendar cal) {
        return new TimestampValue(cal);
    }

    public static IValue create(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof String) {
            return ValueFactory.createString((String)value);
        }
        if (value instanceof Number) {
            Number numValue = (Number)value;
            if (value instanceof BigDecimal) {
                return ValueFactory.createDecimal((BigDecimal)value);
            }
            if (value instanceof Integer) {
                return ValueFactory.createInteger(numValue.intValue());
            }
            if (value instanceof Long) {
                return ValueFactory.createLong(numValue.longValue());
            }
            if (value instanceof Float) {
                return ValueFactory.createFloat(numValue.floatValue());
            }
            return ValueFactory.createDouble(numValue.doubleValue());
        }
        if (value instanceof Boolean) {
            return ValueFactory.createBoolean((Boolean)value);
        }
        if (value instanceof Date) {
            return ValueFactory.createTimestamp((Date)value);
        }
        if (value instanceof Calendar) {
            return ValueFactory.createTimestamp((Calendar)value);
        }
        throw new IllegalArgumentException("Unsupported data type: " + value.getClass().toString());
    }

    public static void encodeBinary(DataOutput out, EncoderContext ctx, IValue value) throws IOException {
        DataTypes.encodeBinary(out, ctx, value.getType());
        value.encodeBinary(out, ctx);
    }

    public static IValue decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        IDataType dataType = DataTypes.decodeBinary(in, ctx);
        IValue value = dataType.newValue();
        value.decodeBinary(in, null);
        return value;
    }

    public static void encodeElement(Element elem, EncoderContext ctx, IValue value) {
        DataTypes.encodeElement(elem, ctx, value.getType());
        value.encodeElement(elem, ctx);
    }

    public static IValue decodeElement(Element elem, EncoderContext ctx) {
        IDataType dataType = DataTypes.decodeElement(elem, ctx);
        IValue value = dataType.newValue();
        value.decodeElement(elem, ctx);
        return value;
    }

    private ValueFactory() {
    }
}

