/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value.decor;

import com.ibm.cognos.aurora.api.model.value.decor.EDecorationType;
import com.ibm.cognos.aurora.api.model.value.decor.IValueDecoration;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.dom4j.Element;

public final class PercentDecoration
implements IValueDecoration {
    private char mPercentSymbol;

    public PercentDecoration(char percentSymbol) {
        this.mPercentSymbol = percentSymbol;
    }

    PercentDecoration() {
    }

    @Override
    public EDecorationType getType() {
        return EDecorationType.PERCENT;
    }

    @Override
    public boolean isPercent() {
        return true;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isThousandsSeparator() {
        return false;
    }

    public char getPercentSymbol() {
        return this.mPercentSymbol;
    }

    @Override
    public void encodeElement(Element elem, EncoderContext ctx) {
        elem.addAttribute("percentSymbol", Character.toString(this.mPercentSymbol));
    }

    @Override
    public void decodeElement(Element elem, EncoderContext ctx) {
        this.mPercentSymbol = elem.attributeValue("percentSymbol").charAt(0);
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        out.writeChar(this.mPercentSymbol);
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        this.mPercentSymbol = in.readChar();
    }

    public String toString() {
        return String.format("PercentDecoration(%s)", Character.toString(this.mPercentSymbol));
    }

    public int hashCode() {
        return this.getType().hashCode() + this.mPercentSymbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PercentDecoration)) {
            return false;
        }
        PercentDecoration other = (PercentDecoration)o;
        return this.mPercentSymbol == other.mPercentSymbol;
    }
}

