/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value.decor;

import com.ibm.cognos.aurora.api.model.value.decor.EDecorationType;
import com.ibm.cognos.aurora.api.model.value.decor.IValueDecoration;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.dom4j.Element;

public class ThousandsSeparatorDecoration
implements IValueDecoration {
    private char mThousandsSeparator;

    public ThousandsSeparatorDecoration(char thousandsSeparator) {
        this.mThousandsSeparator = thousandsSeparator;
    }

    ThousandsSeparatorDecoration() {
        this.mThousandsSeparator = (char)44;
    }

    @Override
    public EDecorationType getType() {
        return EDecorationType.THOUSANDS_SEPARATOR;
    }

    @Override
    public boolean isPercent() {
        return false;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isThousandsSeparator() {
        return true;
    }

    public char getThousandsSeparatorSymbol() {
        return this.mThousandsSeparator;
    }

    @Override
    public void encodeElement(Element elem, EncoderContext ctx) {
        elem.addAttribute("thousandsSeparator", Character.toString(this.mThousandsSeparator));
    }

    @Override
    public void decodeElement(Element elem, EncoderContext ctx) {
        this.mThousandsSeparator = elem.attributeValue("thousandsSeparator").charAt(0);
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        out.writeChar(this.mThousandsSeparator);
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        this.mThousandsSeparator = in.readChar();
    }

    public String toString() {
        return String.format("ThousandsSeparatorDecoration(%s)", Character.toString(this.mThousandsSeparator));
    }

    public int hashCode() {
        return this.getType().hashCode() + this.mThousandsSeparator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThousandsSeparatorDecoration)) {
            return false;
        }
        ThousandsSeparatorDecoration other = (ThousandsSeparatorDecoration)o;
        return this.mThousandsSeparator == other.mThousandsSeparator;
    }
}

