/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value.decor;

import com.ibm.cognos.aurora.api.model.value.decor.CurrencyDecoration;
import com.ibm.cognos.aurora.api.model.value.decor.EDecorationType;
import com.ibm.cognos.aurora.api.model.value.decor.IValueDecoration;
import com.ibm.cognos.aurora.api.model.value.decor.PercentDecoration;
import com.ibm.cognos.aurora.api.model.value.decor.ThousandsSeparatorDecoration;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Element;

public final class ValueDecorations {
    private static final ConcurrentHashMap<Currency, CurrencyDecoration> sCurrencyDecorPool = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Character, PercentDecoration> sPercentDecorPool = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Character, ThousandsSeparatorDecoration> sThousandsSepDecorPool = new ConcurrentHashMap();

    public static CurrencyDecoration getCurrencyDecoration(Currency currency) {
        CurrencyDecoration old;
        CurrencyDecoration decor = sCurrencyDecorPool.get(currency);
        if (null == decor && null != (old = sCurrencyDecorPool.putIfAbsent(currency, decor = new CurrencyDecoration(currency)))) {
            decor = old;
        }
        return decor;
    }

    public static PercentDecoration getPercentDecoration(char percentSymbol) {
        PercentDecoration decor = sPercentDecorPool.get(Character.valueOf(percentSymbol));
        if (null == decor) {
            decor = new PercentDecoration(percentSymbol);
            PercentDecoration old = sPercentDecorPool.putIfAbsent(Character.valueOf(percentSymbol), decor);
            if (null != old) {
                decor = old;
            }
        }
        return decor;
    }

    public static ThousandsSeparatorDecoration geThousandsSeparatorDecoration(char thousandsSepSymbol) {
        ThousandsSeparatorDecoration decor = sThousandsSepDecorPool.get(Character.valueOf(thousandsSepSymbol));
        if (null == decor) {
            decor = new ThousandsSeparatorDecoration(thousandsSepSymbol);
            ThousandsSeparatorDecoration old = sThousandsSepDecorPool.putIfAbsent(Character.valueOf(thousandsSepSymbol), decor);
            if (null != old) {
                decor = old;
            }
        }
        return decor;
    }

    public static void encodeElement(Element elem, EncoderContext ctx, IValueDecoration decoration) {
        elem.addAttribute("type", decoration.getType().name());
        decoration.encodeElement(elem, ctx);
    }

    public static IValueDecoration decodeElement(Element elem, EncoderContext ctx) {
        EDecorationType type = EDecorationType.valueOf(elem.attributeValue("type"));
        IValueDecoration decoration = ValueDecorations.fromDecorationType(type);
        decoration.decodeElement(elem, ctx);
        return decoration;
    }

    public static void encodeBinary(DataOutput out, EncoderContext ctx, IValueDecoration decoration) throws IOException {
        out.writeByte(decoration.getType().ordinal());
        decoration.encodeBinary(out, ctx);
    }

    public static IValueDecoration decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        EDecorationType type = EDecorationType.values()[in.readByte()];
        IValueDecoration decoration = ValueDecorations.fromDecorationType(type);
        decoration.decodeBinary(in, ctx);
        return decoration;
    }

    protected static IValueDecoration fromDecorationType(EDecorationType type) {
        switch (type) {
            case CURRENCY: {
                return new CurrencyDecoration();
            }
            case PERCENT: {
                return new PercentDecoration();
            }
            case THOUSANDS_SEPARATOR: {
                return new ThousandsSeparatorDecoration();
            }
        }
        throw new RuntimeException("Unsupported decoration type: " + type.name());
    }

    private ValueDecorations() {
    }

    static {
        for (ULocale loc : Currency.getAvailableULocales()) {
            Currency cur = Currency.getInstance((ULocale)loc);
            if (null == cur || sCurrencyDecorPool.contains(cur)) continue;
            sCurrencyDecorPool.put(cur, new CurrencyDecoration(cur));
        }
        for (ULocale loc : DecimalFormatSymbols.getAvailableULocales()) {
            char percSym = DecimalFormatSymbols.getInstance((ULocale)loc).getPercent();
            if (sPercentDecorPool.contains(Character.valueOf(percSym))) continue;
            sPercentDecorPool.put(Character.valueOf(percSym), new PercentDecoration(percSym));
        }
    }
}

