/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.storage.data.tabular;

import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.DecimalType;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.datatype.StringType;
import java.util.Arrays;

public class ColumnType {
    private static final ColumnType CLOB = new ColumnType(2005, null);
    private static final ColumnType TINYINT = new ColumnType(-6, null);
    private static final ColumnType SMALLINT = new ColumnType(5, null);
    private static final ColumnType INT = new ColumnType(4, null);
    private static final ColumnType BIGINT = new ColumnType(-5, null);
    private static final ColumnType REAL = new ColumnType(7, null);
    private static final ColumnType DOUBLE = new ColumnType(8, null);
    private static final ColumnType BOOLEAN = new ColumnType(16, null);
    private static final ColumnType DATE = new ColumnType(91, null);
    private static final ColumnType TIME_DEFAULT = new ColumnType(92, null);
    private static final ColumnType TIMESTAMP_DEFAULT = new ColumnType(93, null);
    private final int mBaseType;
    private final Object[] mParams;

    public static ColumnType getChar(int length) {
        return new ColumnType(1, length);
    }

    public static ColumnType getVarChar(int length) {
        return new ColumnType(12, length);
    }

    public static ColumnType getClob() {
        return CLOB;
    }

    public static ColumnType getDecimal(int precision, int scale) {
        return new ColumnType(3, precision, scale);
    }

    public static ColumnType getTinyInt() {
        return TINYINT;
    }

    public static ColumnType getSmallInt() {
        return SMALLINT;
    }

    public static ColumnType getInt() {
        return INT;
    }

    public static ColumnType getBigInt() {
        return BIGINT;
    }

    public static ColumnType getReal() {
        return REAL;
    }

    public static ColumnType getDouble() {
        return DOUBLE;
    }

    public static ColumnType getBoolean() {
        return BOOLEAN;
    }

    public static ColumnType getDate() {
        return DATE;
    }

    public static ColumnType getTime() {
        return TIME_DEFAULT;
    }

    public static ColumnType getTime(int precision, boolean withTimezone) {
        return new ColumnType(92, precision, withTimezone);
    }

    public static ColumnType getTimestamp() {
        return TIMESTAMP_DEFAULT;
    }

    public static ColumnType getTimestamp(int precision, boolean withTimezone) {
        return new ColumnType(93, precision, withTimezone);
    }

    public static ColumnType fromDataType(IDataType dataType) {
        switch (dataType.getBaseType()) {
            case BOOLEAN: {
                return ColumnType.getBoolean();
            }
            case DOUBLE: {
                return ColumnType.getDouble();
            }
            case FLOAT: {
                return ColumnType.getReal();
            }
            case INTEGER: {
                return ColumnType.getInt();
            }
            case LONG: {
                return ColumnType.getBigInt();
            }
            case STRING: {
                return ColumnType.getVarChar(((StringType)dataType).getMaxLength());
            }
            case DATE: {
                return ColumnType.getDate();
            }
            case TIME: {
                return ColumnType.getTime(9, true);
            }
            case TIMESTAMP: {
                return ColumnType.getTimestamp(9, true);
            }
            case DECIMAL: {
                DecimalType decType = (DecimalType)dataType;
                if (decType.getScale() >= 0) {
                    return ColumnType.getDecimal(decType.getPrecision(), decType.getScale());
                }
                return ColumnType.getDecimal(decType.getPrecision() - decType.getScale(), 0);
            }
        }
        return ColumnType.getVarChar(255);
    }

    private ColumnType(int baseType, Object ... params) {
        this.mBaseType = baseType;
        this.mParams = null == params ? new Object[0] : params;
    }

    public boolean isString() {
        switch (this.mBaseType) {
            case 1: 
            case 12: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumeric() {
        switch (this.mBaseType) {
            case -6: 
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public int getBaseType() {
        return this.mBaseType;
    }

    public Object[] getParams() {
        return this.mParams;
    }

    public IDataType toDataType() {
        switch (this.mBaseType) {
            case 1: 
            case 12: {
                return DataTypes.getStringType((Integer)this.mParams[0]);
            }
            case 2005: {
                return DataTypes.getStringType(Integer.MAX_VALUE);
            }
            case 3: {
                if (this.mParams.length == 2) {
                    return DataTypes.getDecimalType((Integer)this.mParams[0], (Integer)this.mParams[1]);
                }
                return DataTypes.getDecimalType((Integer)this.mParams[0]);
            }
            case 8: {
                return DataTypes.getDoubleType();
            }
            case 6: 
            case 7: {
                return DataTypes.getFloatType();
            }
            case -5: {
                return DataTypes.getLongType();
            }
            case -6: 
            case 4: 
            case 5: {
                return DataTypes.getIntegerType();
            }
            case 91: {
                return DataTypes.getDateType();
            }
            case 92: {
                return DataTypes.getTimeType();
            }
            case 93: {
                return DataTypes.getTimestampType();
            }
            case 16: {
                return DataTypes.getBooleanType();
            }
        }
        throw new RuntimeException("Unexpected base type: " + this.mBaseType);
    }

    public String toString() {
        switch (this.mBaseType) {
            case -5: {
                return "BIGINT";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return String.format("CHAR(%d)", this.mParams[0]);
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return String.format("DECIMAL(%d, %d)", this.mParams[0], this.mParams[1]);
            }
            case 8: {
                if (this.mParams.length == 0) {
                    return "DOUBLE";
                }
                return String.format("DOUBLE %d", this.mParams[0]);
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INT";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                if (this.mParams.length == 0) {
                    return "TIME";
                }
                if (Boolean.TRUE.equals(this.mParams[1])) {
                    return String.format("TIME(%d) WITH TIME ZONE", this.mParams[0]);
                }
                return String.format("TIME(%d)", this.mParams[0]);
            }
            case 93: {
                if (this.mParams.length == 0) {
                    return "TIMESTAMP";
                }
                if (Boolean.TRUE.equals(this.mParams[1])) {
                    return String.format("TIMESTAMP(%d) WITH TIME ZONE", this.mParams[0]);
                }
                return String.format("TIMESTAMP(%d)", this.mParams[0]);
            }
            case -6: {
                return "TINYINT";
            }
            case 12: {
                return String.format("VARCHAR(%d)", this.mParams[0]);
            }
        }
        return "?";
    }

    public static ColumnType parse(String text) {
        if ("BIGINT".equals(text)) {
            return ColumnType.getBigInt();
        }
        if ("BOOLEAN".equals(text)) {
            return ColumnType.getBoolean();
        }
        if (text.startsWith("CHAR(")) {
            String lengthStr = text.substring(5, text.length() - 1);
            return ColumnType.getChar(Integer.parseInt(lengthStr));
        }
        if (text.startsWith("VARCHAR(")) {
            String lengthStr = text.substring(8, text.length() - 1);
            return ColumnType.getVarChar(Integer.parseInt(lengthStr));
        }
        if ("CLOB".equals(text)) {
            return ColumnType.getClob();
        }
        if ("DATE".equals(text)) {
            return ColumnType.getDate();
        }
        if (text.startsWith("DECIMAL(")) {
            String paramsStr = text.substring(8, text.length() - 1);
            int commaPos = paramsStr.indexOf(44);
            String param1 = paramsStr.substring(0, commaPos).trim();
            String param2 = paramsStr.substring(commaPos + 1, paramsStr.length()).trim();
            return ColumnType.getDecimal(Integer.parseInt(param1), Integer.parseInt(param2));
        }
        if (text.startsWith("DOUBLE")) {
            return ColumnType.getDouble();
        }
        if ("FLOAT".equals(text) || "REAL".equals(text)) {
            return ColumnType.getReal();
        }
        if ("INT".equals(text)) {
            return ColumnType.getInt();
        }
        if ("SMALLINT".equals(text)) {
            return ColumnType.getSmallInt();
        }
        if ("TINYINT".equals(text)) {
            return ColumnType.getTinyInt();
        }
        if (text.startsWith("TIMESTAMP")) {
            if (text.length() == 9) {
                return ColumnType.getTimestamp();
            }
            int openBracketPos = text.indexOf(40);
            if (-1 == openBracketPos) {
                throw new RuntimeException("Malformed TIMESTAMP");
            }
            int closeBracketPos = text.indexOf(41, openBracketPos + 1);
            if (-1 == closeBracketPos) {
                throw new RuntimeException("Malformed TIMESTAMP");
            }
            String precisionStr = text.substring(openBracketPos + 1, closeBracketPos);
            return ColumnType.getTimestamp(Integer.parseInt(precisionStr), text.endsWith("WITH TIME ZONE"));
        }
        if (text.startsWith("TIME")) {
            if (text.length() == 4) {
                return ColumnType.getTime();
            }
            int openBracketPos = text.indexOf(40);
            if (-1 == openBracketPos) {
                throw new RuntimeException("Malformed TIME");
            }
            int closeBracketPos = text.indexOf(41, openBracketPos + 1);
            if (-1 == closeBracketPos) {
                throw new RuntimeException("Malformed TIME");
            }
            String precisionStr = text.substring(openBracketPos + 1, closeBracketPos);
            return ColumnType.getTime(Integer.parseInt(precisionStr), text.endsWith("WITH TIME ZONE"));
        }
        throw new RuntimeException("Unsupported type: " + text);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnType)) {
            return false;
        }
        ColumnType other = (ColumnType)o;
        return this.mBaseType == other.mBaseType && Arrays.equals(this.mParams, other.mParams);
    }

    public int hashCode() {
        return this.mBaseType + Arrays.hashCode(this.mParams);
    }
}

