/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.util;

import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.api.util.IBinaryEncodable;
import com.ibm.cognos.aurora.api.util.IXMLEncodable;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.core.util.UniqueNameGenerator;
import com.ibm.cognos.aurora.core.util.UniqueNameParser;
import com.ibm.cognos.aurora.core.util.UniqueNameParserException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.dom4j.Element;

public final class MultiPartIdentifier
implements Comparable<MultiPartIdentifier>,
IBinaryEncodable,
IXMLEncodable {
    private String[] mParts;
    private int[] mHashes;
    private int mCachedHashCode = -1;

    public static MultiPartIdentifier fromUniqueName(String uniqueName) {
        try {
            String[] parts = UniqueNameParser.parse((String)uniqueName);
            return new MultiPartIdentifier(parts);
        }
        catch (UniqueNameParserException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public MultiPartIdentifier() {
    }

    public MultiPartIdentifier(String ... parts) {
        this.mParts = parts;
        this.mHashes = new int[parts.length];
        for (int i = 0; i < this.mParts.length; ++i) {
            this.mHashes[i] = this.mParts[i].hashCode();
        }
    }

    public int length() {
        return this.mParts.length;
    }

    public String getPart(int index) {
        return this.mParts[index];
    }

    public String toUniqueName() {
        return UniqueNameGenerator.createUniqueName((String[])this.mParts);
    }

    public MultiPartIdentifier append(String part) {
        String[] newParts = new String[this.mParts.length + 1];
        System.arraycopy(this.mParts, 0, newParts, 0, this.mParts.length);
        newParts[this.mParts.length] = part;
        return new MultiPartIdentifier(newParts);
    }

    @Override
    public int compareTo(MultiPartIdentifier other) {
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        CompareToBuilder cmp = new CompareToBuilder();
        cmp.append((Object[])this.mParts, (Object[])other.mParts);
        return cmp.toComparison();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiPartIdentifier)) {
            return false;
        }
        MultiPartIdentifier other = (MultiPartIdentifier)o;
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        return Arrays.equals(this.mParts, other.mParts);
    }

    public int hashCode() {
        if (-1 == this.mCachedHashCode) {
            int hashCode = Arrays.hashCode(this.mHashes);
            this.mCachedHashCode = -1 == hashCode ? 0 : hashCode;
        }
        return this.mCachedHashCode;
    }

    public String toString() {
        return Arrays.toString(this.mParts);
    }

    @Override
    public void encodeElement(Element elem, EncoderContext ctx) {
        elem.addAttribute("length", Integer.toString(this.mParts.length));
        for (String part : this.mParts) {
            elem.addElement("part").setText(part);
        }
    }

    @Override
    public void decodeElement(Element elem, EncoderContext ctx) {
        int length = Integer.parseInt(elem.attributeValue("length"));
        this.mParts = new String[length];
        this.mHashes = new int[length];
        int i = 0;
        for (Element e : elem.elements("part")) {
            this.mParts[i] = e.getText();
            this.mHashes[i] = this.mParts[i].hashCode();
            ++i;
        }
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        EncodeUtil.writeCompressedInt((DataOutput)out, (int)this.mParts.length);
        for (String part : this.mParts) {
            EncodeUtil.writeString((DataOutput)out, (String)part);
        }
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        int length = EncodeUtil.readCompressedInt((DataInput)in);
        this.mParts = new String[length];
        this.mHashes = new int[length];
        for (int i = 0; i < length; ++i) {
            this.mParts[i] = EncodeUtil.readString((DataInput)in);
            this.mHashes[i] = this.mParts[i].hashCode();
        }
    }
}

