/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.util;

import com.ibm.cognos.aurora.api.query.ISession;
import com.ibm.cognos.aurora.api.util.IObserver;
import com.ibm.cognos.aurora.api.util.IResourceContainer;
import com.ibm.cognos.aurora.api.util.ISessionFactory;
import com.ibm.icu.util.TimeZone;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class SessionCache<T> {
    private final ConcurrentMap<String, CachedSession> cache;

    public SessionCache() {
        this(new ConcurrentHashMap<String, CachedSession>());
    }

    protected SessionCache(ConcurrentMap<String, CachedSession> cache) {
        this.cache = cache;
    }

    public final ISession getOrCreateSession(T arg, ISessionFactory<T> sessionFactory) {
        String key = this.makeKey(arg);
        CachedSession cachedSession = null;
        while (true) {
            if (null == (cachedSession = (CachedSession)this.cache.get(key))) {
                cachedSession = this.makeCachedSession(arg, key, sessionFactory);
                CachedSession existingCachedSession = this.cache.putIfAbsent(key, cachedSession);
                if (null == existingCachedSession) break;
                cachedSession.terminate();
                cachedSession = existingCachedSession;
            }
            if (cachedSession.acquire()) break;
            this.remove(key, cachedSession);
        }
        return cachedSession;
    }

    public final int size() {
        return this.cache.size();
    }

    private boolean remove(String key, ISession session) {
        return this.cache.remove(key, session);
    }

    protected final CachedSession makeCachedSession(T arg, String key, ISessionFactory<T> sessionFactory) {
        ISession session = sessionFactory.createSession(arg);
        return new CachedSession(session, key);
    }

    protected abstract String makeKey(T var1);

    public final class CachedSession
    implements ISession {
        final ISession realSession;
        final String key;
        final AtomicInteger refCount = new AtomicInteger(1);

        CachedSession(ISession realSession, String key) {
            this.realSession = realSession;
            this.key = key;
        }

        private void checkRefCount() {
            if (this.refCount.get() <= 0) {
                throw new IllegalStateException("refCount <= 0");
            }
        }

        private boolean acquire() {
            int count;
            do {
                if ((count = this.refCount.get()) > 0) continue;
                return false;
            } while (!this.refCount.compareAndSet(count, count + 1));
            return true;
        }

        public ISession getRealSession() {
            return this.realSession;
        }

        public int getRefCount() {
            return this.refCount.get();
        }

        @Override
        public void terminate() {
            this.checkRefCount();
            if (0 == this.refCount.decrementAndGet()) {
                SessionCache.this.remove(this.key, this);
                this.realSession.terminate();
            }
        }

        @Override
        public void addObserver(IObserver<ISession> observer) {
            this.checkRefCount();
            this.realSession.addObserver(observer);
        }

        @Override
        public void deleteObserver(IObserver<ISession> Observer) {
            this.checkRefCount();
            this.realSession.deleteObserver(Observer);
        }

        @Override
        public void notifyObservers() {
            this.checkRefCount();
            this.realSession.notifyObservers();
        }

        @Override
        public Locale getContentLocale() {
            this.checkRefCount();
            return this.realSession.getContentLocale();
        }

        @Override
        public Locale getProductLocale() {
            this.checkRefCount();
            return this.realSession.getProductLocale();
        }

        @Override
        public TimeZone getTimeZone() {
            this.checkRefCount();
            return this.realSession.getTimeZone();
        }

        @Override
        public IResourceContainer getResourceContainer() {
            this.checkRefCount();
            return this.realSession.getResourceContainer();
        }
    }
}

