/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.core.bvt.IBVColumnReader;
import com.ibm.cognos.aurora.core.bvt.IBVTableReader;
import java.io.IOException;

public class DefaultBVTableReader
implements IBVTableReader {
    private final IBVColumnReader[] mReaders;

    public DefaultBVTableReader(IBVColumnReader[] readers) {
        this.mReaders = readers;
    }

    @Override
    public boolean isRandomAccess() {
        boolean randAccess = true;
        for (IBVColumnReader reader : this.mReaders) {
            randAccess = randAccess || reader.isRandomAccess();
        }
        return randAccess;
    }

    @Override
    public IValue[] rowAt(long rowNumber) throws IOException {
        IValue[] row = new IValue[this.mReaders.length];
        for (int i = 0; i < this.mReaders.length; ++i) {
            row[i] = this.mReaders[i].at(rowNumber);
        }
        return row;
    }

    @Override
    public IValue[] nextRow() throws IOException {
        IValue[] row = new IValue[this.mReaders.length];
        boolean hasValue = false;
        for (int i = 0; i < this.mReaders.length; ++i) {
            row[i] = this.mReaders[i].next();
            if (hasValue || null == row[i]) continue;
            hasValue = true;
        }
        if (!hasValue) {
            return null;
        }
        return row;
    }

    @Override
    public void reset() throws IOException {
        for (IBVColumnReader r : this.mReaders) {
            r.reset();
        }
    }

    @Override
    public void close() throws IOException {
        for (IBVColumnReader r : this.mReaders) {
            r.close();
        }
    }
}

