/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt.disk;

import com.ibm.cognos.aurora.api.query.data.IValueTupleIterator;
import com.ibm.cognos.aurora.core.bvt.BVTableIteratorAdapter;
import com.ibm.cognos.aurora.core.bvt.DefaultBVTableAppender;
import com.ibm.cognos.aurora.core.bvt.DefaultBVTableReader;
import com.ibm.cognos.aurora.core.bvt.IBVColumn;
import com.ibm.cognos.aurora.core.bvt.IBVColumnAppender;
import com.ibm.cognos.aurora.core.bvt.IBVColumnReader;
import com.ibm.cognos.aurora.core.bvt.IBVTable;
import com.ibm.cognos.aurora.core.bvt.IBVTableAppender;
import com.ibm.cognos.aurora.core.bvt.IBVTableReader;
import com.ibm.cognos.aurora.core.bvt.disk.DiskBVColumn;
import com.ibm.cognos.aurora.core.bvt.disk.DiskBVColumnAppender;
import com.ibm.cognos.aurora.core.bvt.disk.DiskBVColumnReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;

public class DiskBVTable
implements IBVTable {
    private final String mDataDirPath;
    private final ArrayList<DiskBVColumn> mColumns = new ArrayList();
    private int mNextColId = 0;
    private final boolean mRandomAccess;

    public DiskBVTable(String dataDirPath) {
        this.mDataDirPath = dataDirPath;
        this.mRandomAccess = true;
    }

    public DiskBVTable(String dataDirPath, boolean isRandomAccess) {
        this.mDataDirPath = dataDirPath;
        this.mRandomAccess = isRandomAccess;
    }

    @Override
    public boolean isRandomAccess() {
        return this.mRandomAccess;
    }

    public String getDataDirPath() {
        return this.mDataDirPath;
    }

    @Override
    public long numRows() {
        if (this.mColumns.isEmpty()) {
            return 0L;
        }
        return this.mColumns.get(0).getRecordCount();
    }

    @Override
    public int numColumns() {
        return this.mColumns.size();
    }

    @Override
    public IBVColumn[] getColumns() {
        return this.mColumns.toArray(new IBVColumn[0]);
    }

    @Override
    public DiskBVColumn getColumn(int index) {
        return this.mColumns.get(index);
    }

    @Override
    public int indexOf(IBVColumn col) {
        for (int i = 0; i < this.mColumns.size(); ++i) {
            if (!this.mColumns.get(i).equals(col)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DiskBVColumn newColumn() {
        DiskBVColumn col = new DiskBVColumn(this.mDataDirPath + File.separatorChar + this.mNextColId++ + ".bvc", this.mRandomAccess);
        this.mColumns.add(col);
        return col;
    }

    @Override
    public void dropColumn(int index) {
        DiskBVColumn col = this.mColumns.remove(index);
        col.dispose();
    }

    @Override
    public void dropColumn(IBVColumn col) {
        Iterator<DiskBVColumn> colIter = this.mColumns.iterator();
        while (colIter.hasNext()) {
            if (colIter.next() != col) continue;
            colIter.remove();
            col.dispose();
            return;
        }
        throw new RuntimeException("Column not in table: " + String.valueOf(col));
    }

    @Override
    public IBVTableAppender openAppender() throws IOException {
        IBVColumnAppender[] appenders = new DiskBVColumnAppender[this.mColumns.size()];
        try {
            for (int i = 0; i < this.mColumns.size(); ++i) {
                appenders[i] = this.mColumns.get(i).openAppender();
            }
        }
        catch (Exception ex) {
            for (int i = 0; i < this.mColumns.size(); ++i) {
                if (null == appenders[i]) continue;
                ((DiskBVColumnAppender)appenders[i]).close();
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw (RuntimeException)ex;
        }
        return new DefaultBVTableAppender(appenders);
    }

    @Override
    public IBVTableReader openReader() throws IOException {
        IBVColumnReader[] readers = new DiskBVColumnReader[this.mColumns.size()];
        try {
            for (int i = 0; i < this.mColumns.size(); ++i) {
                readers[i] = this.mColumns.get(i).openReader();
            }
        }
        catch (Exception ex) {
            for (int i = 0; i < this.mColumns.size(); ++i) {
                if (null == readers[i]) continue;
                ((DiskBVColumnReader)readers[i]).close();
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw (RuntimeException)ex;
        }
        return new DefaultBVTableReader(readers);
    }

    @Override
    public IValueTupleIterator openIterator() throws IOException {
        return new BVTableIteratorAdapter(this.openReader(), this.numRows());
    }

    @Override
    public void clear() throws IOException {
        for (DiskBVColumn c : this.mColumns) {
            c.clear();
        }
    }

    @Override
    public void dispose() {
        for (DiskBVColumn c : this.mColumns) {
            c.dispose();
        }
        this.mColumns.clear();
        try {
            File dataDir = new File(this.mDataDirPath);
            if (dataDir.exists()) {
                FileUtils.deleteDirectory((File)dataDir);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

