/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt.heap;

import com.ibm.cognos.aurora.api.query.data.IValueTupleIterator;
import com.ibm.cognos.aurora.core.bvt.BVTableIteratorAdapter;
import com.ibm.cognos.aurora.core.bvt.DefaultBVTableReader;
import com.ibm.cognos.aurora.core.bvt.IBVColumn;
import com.ibm.cognos.aurora.core.bvt.IBVColumnReader;
import com.ibm.cognos.aurora.core.bvt.IBVTable;
import com.ibm.cognos.aurora.core.bvt.IBVTableReader;
import com.ibm.cognos.aurora.core.bvt.heap.HeapBVColumn;
import com.ibm.cognos.aurora.core.bvt.heap.HeapBVColumnAppender;
import com.ibm.cognos.aurora.core.bvt.heap.HeapBVColumnReader;
import com.ibm.cognos.aurora.core.bvt.heap.HeapBVTableAppender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class HeapBVTable
implements IBVTable {
    private final ArrayList<HeapBVColumn> mColumns = new ArrayList();

    @Override
    public long numRows() {
        if (this.mColumns.isEmpty()) {
            return 0L;
        }
        return this.mColumns.get(0).getRecordCount();
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public int numColumns() {
        return this.mColumns.size();
    }

    @Override
    public IBVColumn[] getColumns() {
        return this.mColumns.toArray(new IBVColumn[0]);
    }

    @Override
    public HeapBVColumn getColumn(int index) {
        return this.mColumns.get(index);
    }

    @Override
    public int indexOf(IBVColumn col) {
        for (int i = 0; i < this.mColumns.size(); ++i) {
            if (!this.mColumns.get(i).equals(col)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public HeapBVColumn newColumn() {
        HeapBVColumn col = new HeapBVColumn();
        this.mColumns.add(col);
        return col;
    }

    @Override
    public void dropColumn(int index) {
        HeapBVColumn col = this.mColumns.remove(index);
        col.dispose();
    }

    @Override
    public void dropColumn(IBVColumn col) {
        Iterator<HeapBVColumn> colIter = this.mColumns.iterator();
        while (colIter.hasNext()) {
            if (colIter.next() != col) continue;
            colIter.remove();
            col.dispose();
            return;
        }
        throw new RuntimeException("Column not in table: " + String.valueOf(col));
    }

    @Override
    public HeapBVTableAppender openAppender() throws IOException {
        HeapBVColumnAppender[] appenders = new HeapBVColumnAppender[this.mColumns.size()];
        try {
            for (int i = 0; i < this.mColumns.size(); ++i) {
                appenders[i] = this.mColumns.get(i).openAppender();
            }
        }
        catch (Exception ex) {
            for (int i = 0; i < this.mColumns.size(); ++i) {
                if (null == appenders[i]) continue;
                appenders[i].close();
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw (RuntimeException)ex;
        }
        return new HeapBVTableAppender(appenders);
    }

    @Override
    public IBVTableReader openReader() throws IOException {
        IBVColumnReader[] readers = new HeapBVColumnReader[this.mColumns.size()];
        try {
            for (int i = 0; i < this.mColumns.size(); ++i) {
                readers[i] = this.mColumns.get(i).openReader();
            }
        }
        catch (Exception ex) {
            for (int i = 0; i < this.mColumns.size(); ++i) {
                if (null == readers[i]) continue;
                ((HeapBVColumnReader)readers[i]).close();
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw (RuntimeException)ex;
        }
        return new DefaultBVTableReader(readers);
    }

    @Override
    public IValueTupleIterator openIterator() throws IOException {
        return new BVTableIteratorAdapter(this.openReader(), this.numRows());
    }

    @Override
    public void clear() throws IOException {
        for (HeapBVColumn c : this.mColumns) {
            c.clear();
        }
    }

    @Override
    public void dispose() {
        for (HeapBVColumn c : this.mColumns) {
            c.dispose();
        }
        this.mColumns.clear();
    }
}

