/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt.hybrid;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.core.bvt.IBVColumnAppender;
import com.ibm.cognos.aurora.core.bvt.disk.DiskBVColumn;
import com.ibm.cognos.aurora.core.bvt.heap.HeapBVColumn;
import java.io.IOException;

public class HybridBVColumnAppender
implements IBVColumnAppender {
    private HeapBVColumn mHeapColumn;
    private DiskBVColumn mDiskColumn;
    private IBVColumnAppender mCurrentAppender;

    public HybridBVColumnAppender(HeapBVColumn heapColumn, DiskBVColumn diskColumn) throws IOException {
        this.mHeapColumn = heapColumn;
        this.mDiskColumn = diskColumn;
        this.mCurrentAppender = this.mHeapColumn.openAppender();
    }

    @Override
    public void append(IValue value) throws IOException {
        if (null == this.mCurrentAppender) {
            throw new IllegalStateException("Appender was closed.");
        }
        this.mCurrentAppender.append(value);
    }

    @Override
    public void flush() throws IOException {
        if (null == this.mCurrentAppender) {
            throw new IllegalStateException("Appender was closed.");
        }
        this.mCurrentAppender.flush();
    }

    @Override
    public void close() throws IOException {
        if (null != this.mCurrentAppender) {
            this.mCurrentAppender.close();
            this.mCurrentAppender = null;
            this.mHeapColumn = null;
            this.mDiskColumn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void spillOver() throws IOException {
        if (null == this.mCurrentAppender) {
            throw new IllegalStateException("Appender was closed.");
        }
        long heapCount = this.mHeapColumn.getRecordCount();
        this.mCurrentAppender.close();
        this.mCurrentAppender = this.mDiskColumn.openAppender();
        IValueIterator heapIter = this.mHeapColumn.openIterator();
        try {
            while (heapIter.hasNext()) {
                this.mCurrentAppender.append(heapIter.next());
            }
        }
        finally {
            heapIter.close();
            this.mHeapColumn = null;
        }
        if (this.mDiskColumn.getRecordCount() != heapCount) {
            throw new RuntimeException("Record count mismatch after disk spill over.");
        }
    }
}

