/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt.hybrid;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.core.bvt.DefaultBVTableAppender;
import com.ibm.cognos.aurora.core.bvt.IBVColumnAppender;
import com.ibm.cognos.aurora.core.bvt.hybrid.HybridBVColumnAppender;
import com.ibm.cognos.aurora.core.bvt.hybrid.HybridBVTable;
import java.io.IOException;

public class HybridBVTableAppender
extends DefaultBVTableAppender {
    private static final long SPILLOVER_CELL_THRESHOLD = 100000L;
    private final HybridBVTable mTable;
    private final long mSpillOverRowThreshold;

    public HybridBVTableAppender(HybridBVTable table, IBVColumnAppender[] appenders) {
        super(appenders);
        this.mTable = table;
        this.mSpillOverRowThreshold = 100000L / (long)Math.max(1, table.numColumns());
    }

    @Override
    public void appendRow(IValue[] row) throws IOException {
        super.appendRow(row);
        if (!this.mTable.isSpilledOver() && this.mTable.numRows() > this.mSpillOverRowThreshold) {
            for (IBVColumnAppender appender : this.mAppenders) {
                ((HybridBVColumnAppender)appender).spillOver();
            }
            this.mTable.spillOver();
        }
    }
}

