/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt.union;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.core.bvt.IBVColumn;
import com.ibm.cognos.aurora.core.bvt.IBVColumnAppender;
import com.ibm.cognos.aurora.core.bvt.IBVColumnReader;
import com.ibm.cognos.aurora.core.bvt.union.UnionBVColumnReader;
import java.io.IOException;
import java.util.NoSuchElementException;

public class UnionBVColumn
implements IBVColumn {
    private final IBVColumn[] mSubColumns;
    private final long mRecordCount;
    private final boolean mRandomAccess;

    public UnionBVColumn(IBVColumn[] subColumns) {
        this.mSubColumns = subColumns;
        long recordCount = 0L;
        boolean isRandomAccess = true;
        for (IBVColumn col : this.mSubColumns) {
            recordCount += col.getRecordCount();
            isRandomAccess = isRandomAccess || col.isRandomAccess();
        }
        this.mRecordCount = recordCount;
        this.mRandomAccess = isRandomAccess;
    }

    @Override
    public boolean isRandomAccess() {
        return this.mRandomAccess;
    }

    @Override
    public long getRecordCount() {
        return this.mRecordCount;
    }

    @Override
    public IBVColumnAppender openAppender() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IBVColumnReader openReader() throws IOException {
        IBVColumnReader[] subReaders = new IBVColumnReader[this.mSubColumns.length];
        long[] extents = new long[this.mSubColumns.length];
        for (int i = 0; i < this.mSubColumns.length; ++i) {
            subReaders[i] = this.mSubColumns[i].openReader();
            if (!this.mRandomAccess) continue;
            extents[i] = this.mSubColumns[i].getRecordCount();
        }
        return new UnionBVColumnReader(subReaders, extents, this.mRandomAccess);
    }

    @Override
    public IValueIterator openIterator() throws IOException {
        return new Iter(this.openReader());
    }

    @Override
    public void copyFrom(IBVColumn source) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    private final class Iter
    implements IValueIterator {
        private final IBVColumnReader mReader;
        private long mNextIndex = 0L;

        Iter(IBVColumnReader reader) {
            this.mReader = reader;
        }

        public boolean hasNext() {
            return this.mNextIndex < UnionBVColumn.this.mRecordCount;
        }

        public IValue next() {
            if (this.mNextIndex >= UnionBVColumn.this.mRecordCount) {
                throw new NoSuchElementException();
            }
            try {
                IValue v = this.mReader.next();
                ++this.mNextIndex;
                return v;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void reset() {
            this.mNextIndex = 0L;
            try {
                this.mReader.reset();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void close() {
            try {
                this.mReader.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

