/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt.union;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.core.bvt.IBVColumnReader;
import java.io.IOException;

public class UnionBVColumnReader
implements IBVColumnReader {
    private final IBVColumnReader[] mSubReaders;
    private final long[] mExtents;
    private final boolean mRandomAccess;
    private int mReaderIndex = 0;

    public UnionBVColumnReader(IBVColumnReader[] subReaders, long[] extents, boolean isRandomAccess) {
        this.mSubReaders = subReaders;
        this.mExtents = extents;
        this.mRandomAccess = isRandomAccess;
    }

    @Override
    public boolean isRandomAccess() {
        return this.mRandomAccess;
    }

    @Override
    public IValue at(long index) throws IOException {
        if (!this.mRandomAccess) {
            throw new UnsupportedOperationException();
        }
        if (index < 0L) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < this.mExtents.length; ++i) {
            if (index >= this.mExtents[i]) {
                index -= this.mExtents[i];
                continue;
            }
            this.mReaderIndex = i;
            break;
        }
        if (index > this.mExtents[this.mExtents.length - 1]) {
            throw new IndexOutOfBoundsException();
        }
        return this.mSubReaders[this.mReaderIndex].at(index);
    }

    @Override
    public IValue next() throws IOException {
        IValue v = this.mSubReaders[this.mReaderIndex].next();
        while (null == v && this.mReaderIndex + 1 < this.mSubReaders.length) {
            ++this.mReaderIndex;
            this.mSubReaders[this.mReaderIndex].reset();
            v = this.mSubReaders[this.mReaderIndex].next();
        }
        return v;
    }

    @Override
    public void reset() throws IOException {
        this.mReaderIndex = 0;
        this.mSubReaders[0].reset();
    }

    @Override
    public void close() throws IOException {
        for (IBVColumnReader reader : this.mSubReaders) {
            reader.close();
        }
    }
}

