/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.ast;

import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.core.expert.ast.IXQENodeFactory;
import com.ibm.cognos.aurora.core.expert.ast.IXQEProperty;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQEBaseQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class XQEQueryNode
extends XQEBaseQueryNode {
    private static final String STRING_PROPERTY_KEY = "key";
    private static final String STRING_LINEAGE = "lineage";
    protected Map<String, Object> mProperties = new HashMap<String, Object>();
    private ArrayList<IXQEQueryNode> mLineage;
    protected boolean mRootOfSubtree;
    private ArrayList<IXQEQueryNode> mLineageTargets;

    protected XQEQueryNode() {
    }

    public void copyPropertiesTo(XQEQueryNode target) {
        for (Map.Entry<String, Object> entry : this.mProperties.entrySet()) {
            target.setPropertyValue(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final Map<String, Object> getProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.mProperties.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    @Override
    public Object getPropertyValue(String key) {
        return this.mProperties.get(key);
    }

    @Override
    public final void removeProperty(String key) {
        boolean trace;
        XQETrace traceObj = this.getPlanningEnvironment().getTrace();
        if (traceObj != null && (trace = traceObj.isEnable(256))) {
            traceObj.beginElement("removeProperty", this.getId());
            traceObj.attribute(STRING_PROPERTY_KEY, key);
            traceObj.endElement();
        }
        this.mProperties.remove(key);
        this.setTreeHasBeenModified();
    }

    @Override
    public final Boolean getBooleanPropertyValue(String key) {
        Object value = this.mProperties.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }

    public final Boolean getBooleanPropertyValue(String key, Boolean defaultValue) {
        Object value = this.mProperties.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    @Override
    public final Integer getIntegerPropertyValue(String key) {
        Object value = this.mProperties.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    @Override
    public final Float getFloatPropertyValue(String key) {
        Object value = this.mProperties.get(key);
        if (value instanceof Float) {
            return (Float)value;
        }
        return null;
    }

    @Override
    public final Double getDoublePropertyValue(String key) {
        Object value = this.mProperties.get(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        return null;
    }

    @Override
    public String getPropertyValueAsXML(String propertyName) {
        return null;
    }

    public final void setProperties(HashMap<String, Object> map) {
        this.mProperties.putAll(map);
    }

    @Override
    public void setPropertyValue(String key, Object value) {
        boolean trace;
        XQETrace traceObj;
        if (this.getPlanningEnvironment() != null && (traceObj = this.getPlanningEnvironment().getTrace()) != null && (trace = traceObj.isEnable(256))) {
            traceObj.beginElement("setPropertyValue", this.getId());
            traceObj.attribute(STRING_PROPERTY_KEY, key);
            if (value != null) {
                traceObj.attribute("value", value);
            }
            traceObj.endElement();
        }
        this.mProperties.put(key, value);
        this.setTreeHasBeenModified();
    }

    @Override
    public void dumpProperties(XQETrace trace) {
        Object value;
        for (String key : this.getProperties().keySet()) {
            List<String> arrayValues;
            value = this.getPropertyValue(key);
            if (value instanceof IXQEProperty) continue;
            if (value instanceof String[]) {
                arrayValues = Arrays.asList((String[])value);
                trace.attribute(key, arrayValues.toString());
                continue;
            }
            if (value instanceof INode[]) {
                arrayValues = Arrays.asList((INode[])value);
                trace.attribute(key, arrayValues.toString());
                continue;
            }
            if (value instanceof IMember[]) {
                arrayValues = Arrays.asList((IMember[])value);
                trace.attribute(key, arrayValues.toString());
                continue;
            }
            if (value instanceof IAttribute[]) {
                arrayValues = Arrays.asList((IAttribute[])value);
                trace.attribute(key, arrayValues.toString());
                continue;
            }
            if (value != null) {
                trace.attribute(key, value.toString());
                continue;
            }
            trace.attribute(key, "null");
        }
        for (String key : this.getProperties().keySet()) {
            value = this.getPropertyValue(key);
            if (!(value instanceof IXQEProperty) || (trace.getTraceLevel() & 0x40) == 0) continue;
            ((IXQEProperty)value).toXMLString(trace);
        }
    }

    public void capture(PlanningEnvironment env, Element inputNode) {
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            this.setPropertyValue(attname, att.getValue());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            IXQEQueryNode node = factory.createNode(childname);
            if (node == null) {
                throw new RuntimeException(childname);
            }
            this.addChild(node);
            ((XQEQueryNode)node).capture(env, child);
        }
    }

    @Override
    public void setLineage(IXQEQueryNode lineage) {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        if (lineage == null) {
            return;
        }
        if (this.mLineage == null) {
            this.mLineage = new ArrayList();
        } else {
            this.mLineage.clear();
        }
        this.mLineage.add(lineage);
    }

    @Override
    public void setLineage(IXQEQueryNode[] lineage) {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        if (lineage == null) {
            return;
        }
        if (this.mLineage == null) {
            this.mLineage = new ArrayList();
        }
        for (int i = 0; i < lineage.length; ++i) {
            this.mLineage.add(lineage[i]);
        }
    }

    @Override
    public void setLineage(ArrayList<IXQEQueryNode> lineage) {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        if (lineage == null) {
            return;
        }
        if (this.mLineage == null) {
            this.mLineage = new ArrayList();
        }
        int size = lineage.size();
        for (int i = 0; i < size; ++i) {
            this.mLineage.add(lineage.get(i));
        }
    }

    @Override
    protected void transferLineageToNode(IXQEQueryNode target) {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        this.addLineageToNode(target);
        this.deleteLineage(false);
    }

    @Override
    protected void copyLineageToNode(IXQEQueryNode target) {
        PlanningEnvironment env = this.getPlanningEnvironment();
        if (env == null || !env.getQueryLineageTrackingEnabled()) {
            return;
        }
        this.addLineageToNode(target);
    }

    @Override
    protected void transferLineageToNode(IXQEQueryNode target, boolean includeSelf) {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        IXQEQueryNode[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            ((XQEBaseQueryNode)children[i]).transferLineageToNode(target, true);
        }
        if (includeSelf) {
            this.addLineageToNode(target);
        }
        this.deleteLineage(false);
    }

    private void addLineageToNode(IXQEQueryNode target) {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        if (target != null) {
            ((XQEBaseQueryNode)target).setLineage(this.getLineage());
        }
    }

    @Override
    public void deleteLineage(boolean deleteChildLineage) {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        if (this.mLineage != null) {
            this.mLineage.clear();
            if (deleteChildLineage) {
                this.mLineage = null;
            }
        }
        if (deleteChildLineage) {
            int numberChildren = this.getNumberChildren();
            for (int i = 0; i < numberChildren; ++i) {
                ((XQEBaseQueryNode)this.getChild(i)).deleteLineage(deleteChildLineage);
            }
        }
    }

    @Override
    public ArrayList<IXQEQueryNode> getLineage() {
        return this.mLineage;
    }

    @Override
    public void initializeLineage(IXQEQueryNode target) {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        target.setNodeId(this.getId());
        this.setLineage(target);
        IXQEQueryNode[] sourceChildren = this.getChildren();
        IXQEQueryNode[] targetChildren = target.getChildren();
        for (int i = 0; i < sourceChildren.length; ++i) {
            sourceChildren[i].initializeLineage(targetChildren[i]);
        }
    }

    private void dumpNodeLineage(XQETrace trace) {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        ArrayList<IXQEQueryNode> lineage = this.getLineage();
        if (lineage == null || lineage.size() == 0) {
            return;
        }
        Iterator<IXQEQueryNode> it = this.getLineage().iterator();
        StringBuilder buffer = new StringBuilder();
        while (it.hasNext()) {
            XQEBaseQueryNode node = (XQEBaseQueryNode)it.next();
            buffer.append(node.getId().toString());
            if (!it.hasNext()) continue;
            buffer.append(",");
        }
        trace.attribute(STRING_LINEAGE, buffer.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dumpLineage(XQETrace trace) {
        void var4_7;
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        ArrayList<IXQEQueryNode> lineage = this.getLineage();
        if (lineage != null && lineage.size() > 0) {
            trace.beginElement("node", -1);
            trace.attribute("id", this.getId());
            for (XQEBaseQueryNode xQEBaseQueryNode : this.getLineage()) {
                trace.beginElement(STRING_LINEAGE, -1);
                trace.attribute("id", xQEBaseQueryNode.getId());
                trace.endElement();
            }
            trace.endElement();
        }
        int numberChildren = this.getNumberChildren();
        boolean bl = false;
        while (var4_7 < numberChildren) {
            ((XQEBaseQueryNode)this.getChild((int)var4_7)).dumpLineage(trace);
            ++var4_7;
        }
    }

    @Override
    public void setAsRootOfSubtree(String name, String subTreeType) {
        this.setAsRootOfSubtree(name, subTreeType, 0);
    }

    @Override
    public void setAsRootOfSubtree(String name, String subTreeType, int leafNodeDelimiter) {
        if (this.mRootOfSubtree) {
            return;
        }
        XQETrace traceObj = this.getPlanningEnvironment().getTrace();
        traceObj.beginElement(256, "markSubTree", this.getId());
        if (name != null) {
            traceObj.attribute(256, "name", name);
        }
        if (subTreeType != null) {
            traceObj.attribute(256, "subTreeType", subTreeType);
        }
        if (leafNodeDelimiter != 0) {
            traceObj.attribute(256, "leafNodeType", leafNodeDelimiter);
        }
        traceObj.endElement(256);
        this.mRootOfSubtree = true;
    }

    @Override
    public void removeSubtreeDefinition() {
        if (!this.mRootOfSubtree) {
            return;
        }
        XQETrace traceObj = this.getPlanningEnvironment().getTrace();
        boolean trace = traceObj.isEnable(256);
        if (trace) {
            traceObj.beginElement("removeSubTree", this.getId());
            traceObj.endElement();
        }
        this.mRootOfSubtree = false;
    }

    @Override
    public boolean getIsRootOfSubtree() {
        return this.mRootOfSubtree;
    }

    @Override
    public void copyContentTo(IXQENodeFactory nodeFactory, IXQEQueryNode node) {
        super.copyContentTo(nodeFactory, node);
        for (String key : this.getProperties().keySet()) {
            Object value = this.getPropertyValue(key);
            node.setPropertyValue(key, value);
        }
    }

    @Override
    public void resolveValueOfQueryNodeProperties(Map<IXQEQueryNode, IXQEQueryNode> map) {
        super.resolveValueOfQueryNodeProperties(map);
        for (Map.Entry<String, Object> entry : this.mProperties.entrySet()) {
            IXQEQueryNode newNode;
            if (!(entry.getValue() instanceof IXQEQueryNode) || (newNode = map.get(entry.getValue())) == null) continue;
            entry.setValue(newNode);
        }
    }

    @Override
    public void dump(XQETrace trace, boolean includeNodeID) {
        Integer nodeID = -1;
        if (includeNodeID) {
            nodeID = this.getId();
        }
        trace.beginElement(this.getNodeTypeName(), nodeID);
        this.dumpProperties(trace);
        this.dumpExtraInfo(trace);
        this.dumpNodeLineage(trace);
        int numberChildren = this.getNumberChildren();
        for (int i = 0; i < numberChildren; ++i) {
            this.getChild(i).dump(trace, includeNodeID);
        }
        trace.endElement();
    }

    @Override
    protected void addLineageTarget(IXQEQueryNode node, boolean includeChildren) {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        if (this.mLineageTargets == null) {
            this.mLineageTargets = new ArrayList();
        }
        this.mLineageTargets.add(node);
        int numberChildren = this.getNumberChildren();
        for (int i = 0; i < numberChildren; ++i) {
            XQEBaseQueryNode child = (XQEBaseQueryNode)this.getChild(i);
            if (child == null) continue;
            child.addLineageTarget(node, includeChildren);
        }
    }

    @Override
    protected ArrayList<IXQEQueryNode> getLineageTargets() {
        return this.mLineageTargets;
    }

    @Override
    public void cleanUpNode() {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        super.cleanUpNode();
        if (this.getLineageTargets() != null) {
            Iterator<IXQEQueryNode> it = this.getLineageTargets().iterator();
            while (it.hasNext()) {
                this.transferLineageToNode(it.next());
            }
            this.clearListOfLineageTargets();
        }
    }

    private void clearListOfLineageTargets() {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        this.mLineageTargets.clear();
    }

    @Override
    protected void establishLineageTransferForExtractedNode(IXQEQueryNode targetNode) {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        int numberChildren = this.getNumberChildren();
        if (numberChildren == 0) {
            return;
        }
        for (int i = 0; i < numberChildren; ++i) {
            ((XQEBaseQueryNode)targetNode).addLineageTarget(this.getChild(i), true);
        }
    }

    @Override
    public boolean validateChildCategories() {
        if (!this.isNodeChanged()) {
            return this.hasValidChildren();
        }
        this.setNodeChanged(false);
        boolean result = false;
        int numberOfChildren = this.getNumberChildren();
        if (numberOfChildren >= this.getMinimumNumberChildren()) {
            result = true;
            for (int i = 0; i < numberOfChildren; ++i) {
                IXQEQueryNode child = this.getChild(i);
                if (child.isOfCategories(this.getRequiredCategoriesForChildAtIndex(i))) continue;
                result = false;
                break;
            }
        }
        this.setHasValidChildren(result);
        return result;
    }

    public boolean validateDescendantCategories() {
        return this.getInvalidDescendantNode() == null;
    }

    public IXQEQueryNode getInvalidDescendantNode() {
        int i;
        int numberChildren = this.getNumberChildren();
        if (numberChildren < this.getMinimumNumberChildren()) {
            return this;
        }
        for (i = 0; i < numberChildren; ++i) {
            IXQEQueryNode child = this.getChild(i);
            if (child.isOfCategories(this.getRequiredCategoriesForChildAtIndex(i))) continue;
            return child;
        }
        for (i = 0; i < numberChildren; ++i) {
            IXQEQueryNode invalidChild = ((XQEQueryNode)this.getChild(i)).getInvalidDescendantNode();
            if (invalidChild == null) continue;
            return invalidChild;
        }
        return null;
    }
}

