/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.inference;

import com.ibm.cognos.aurora.core.expert.bibusservice.RequestEnvironment;
import com.ibm.cognos.aurora.core.expert.config.ServiceEnumeration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfiguration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfigurationManager;

public final class QueryEngineLoggingUtils {
    public static final String XML_ELEMENT_EXECUTION_TRACE_ATTRIBUTE_ENABLED = "queryExecution[@traceEnabled]";
    public static final String XML_ELEMENT_PLANNING_TRACE_ATTRIBUTE_ENABLED = "queryPlanning[@traceEnabled]";

    public static boolean isTracingEnabled(RequestEnvironment reqEnv) {
        return QueryEngineLoggingUtils.isTracingEnabled(XML_ELEMENT_PLANNING_TRACE_ATTRIBUTE_ENABLED, reqEnv) || QueryEngineLoggingUtils.isTracingEnabled(XML_ELEMENT_EXECUTION_TRACE_ATTRIBUTE_ENABLED, reqEnv);
    }

    public static boolean isPlanningTraceEnabled(RequestEnvironment reqEnv) {
        return QueryEngineLoggingUtils.isTracingEnabled(XML_ELEMENT_PLANNING_TRACE_ATTRIBUTE_ENABLED, reqEnv);
    }

    public static boolean isExecutionTraceEnabled(RequestEnvironment reqEnv) {
        return QueryEngineLoggingUtils.isTracingEnabled(XML_ELEMENT_EXECUTION_TRACE_ATTRIBUTE_ENABLED, reqEnv);
    }

    private static boolean isTracingEnabled(String traceProperty, RequestEnvironment reqEnv) {
        if (reqEnv == null) {
            return false;
        }
        int traceValue = reqEnv.getTraceEnabled();
        if (traceValue == -1) {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.AURORA);
            int serverSetting = 0;
            if (config.getBooleanProperty(XML_ELEMENT_EXECUTION_TRACE_ATTRIBUTE_ENABLED, false)) {
                serverSetting |= 1;
            }
            if (config.getBooleanProperty(XML_ELEMENT_PLANNING_TRACE_ATTRIBUTE_ENABLED, false)) {
                serverSetting |= 2;
            }
            int[] parsedValue = new int[]{serverSetting};
            traceValue = parsedValue[0];
            reqEnv.setTraceEnabled(traceValue);
        }
        switch (traceValue) {
            case 0: {
                return false;
            }
            case 1: {
                return traceProperty.equals(XML_ELEMENT_EXECUTION_TRACE_ATTRIBUTE_ENABLED);
            }
            case 2: {
                return traceProperty.equals(XML_ELEMENT_PLANNING_TRACE_ATTRIBUTE_ENABLED);
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static void setPlanningTraceEnabled(boolean enabled) {
        QueryEngineLoggingUtils.setTraceEnabled(XML_ELEMENT_PLANNING_TRACE_ATTRIBUTE_ENABLED);
    }

    public static void setExecutionTraceEnabled(boolean enabled) {
        QueryEngineLoggingUtils.setTraceEnabled(XML_ELEMENT_EXECUTION_TRACE_ATTRIBUTE_ENABLED);
    }

    private static void setTraceEnabled(String traceProperty) {
        XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.AURORA).setProperty(traceProperty, "true");
    }
}

