/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.rules;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.config.ServiceEnumeration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfiguration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfigurationManager;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.inference.QTESharedPassNumbers;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRuleLibrary;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;

public abstract class AbstractRule {
    private static final String PASSES_QUERY_CONDITION = "passesQueryCondition";
    private static final String PASSES_NODE_CONDITION = "passesNodeCondition";
    private static final String EXCEPTION_MESSAGE = "exceptionMessage";
    private static final String NO_QUERY_CONDITION = "No Query Condition";
    private static final String NO_NODE_CONDITION = "No Node Condition";
    private static final String PASS = "pass";
    private static final String VALUE_TRUE = "true";
    private static final String VALUE_FALSE = "false";
    private static final String REASON = "reason";
    protected int[] mPassNumbers = new int[]{-1};
    protected int[] mTypes = null;
    protected String mName = null;
    protected boolean mBottomUpRestart = false;
    protected Mode mMode = Mode.UNDEFINED;
    protected ApplicableIterations mApplicableIterations = ApplicableIterations.UNDEFINED;
    private AbstractRuleLibrary mLibrary;
    private static boolean mDeterminedIfLibraryPreceedsName;
    private static boolean mPreceedNameByLibraryName;
    private boolean mSharedPassNumbers = false;

    public AbstractRule() {
        this.mSharedPassNumbers = false;
    }

    public AbstractRule(QTESharedPassNumbers sharedPassNumbers) {
        this.mPassNumbers = sharedPassNumbers.getPassNumbers();
        this.mSharedPassNumbers = true;
    }

    public final int[] getPassNumbers() {
        return this.mPassNumbers;
    }

    public final int[] getTypes() {
        return this.mTypes;
    }

    public final String getName() {
        String name;
        if (this.mName == null) {
            name = this.getClass().getName();
            name = name.substring(name.lastIndexOf(46) + 1);
        } else {
            name = this.mName;
        }
        AbstractRule.determineIfNamePreceededByLibraryName();
        if (mPreceedNameByLibraryName) {
            name = this.getTransformationLibrary().getLibraryName() + ":" + name;
        }
        return name;
    }

    public final Mode getMode() {
        return this.mMode;
    }

    public void resolveMode(Mode libraryValue) {
        if (this.mMode == Mode.UNDEFINED) {
            this.mMode = libraryValue;
            if (this.mMode == Mode.UNDEFINED) {
                this.mMode = Mode.INDEXED;
            }
        }
    }

    public final boolean getBottomUpRestart() {
        return this.mBottomUpRestart;
    }

    public final ApplicableIterations getApplicableIterations() {
        return this.mApplicableIterations;
    }

    public final void resolveApplicableIterations(ApplicableIterations libraryValue) {
        if (this.mApplicableIterations == ApplicableIterations.UNDEFINED) {
            this.mApplicableIterations = libraryValue;
            if (this.mApplicableIterations == ApplicableIterations.UNDEFINED) {
                this.mApplicableIterations = ApplicableIterations.UNLIMITED;
            }
        }
    }

    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = true;
        XQETrace trace = environment.getTrace();
        this.traceQueryCondition(status, NO_QUERY_CONDITION, trace);
        return status;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = true;
        XQETrace trace = environment.getTrace();
        this.traceNodeCondition(status, NO_NODE_CONDITION, trace);
        return status;
    }

    public abstract void apply(IXQEQueryNode var1, PlanningEnvironment var2);

    public void dump(XQETrace trace) {
        trace.beginElement("transformation", -1);
        trace.attribute("name", this.getName());
        trace.attribute("className", this.getClass().getName());
        this.dumpSpecificationReferences(trace);
        trace.endElement();
    }

    public void dumpSpecificationReferences(XQETrace trace) {
    }

    public final void traceQueryCondition(boolean status, String reason, XQETrace trace) {
        if (status) {
            if ((trace.getTraceLevel() & 2) != 0) {
                trace.beginElement(PASSES_QUERY_CONDITION, -1);
                trace.attribute(PASS, VALUE_TRUE);
                trace.attribute(REASON, reason);
                trace.endElement();
            }
        } else if ((trace.getTraceLevel() & 4) != 0) {
            trace.beginElement(PASSES_QUERY_CONDITION, -1);
            trace.attribute(PASS, VALUE_FALSE);
            trace.attribute(REASON, reason);
            trace.endElement();
        }
    }

    public final void traceNodeCondition(boolean status, String reason, XQETrace trace) {
        if (status) {
            if ((trace.getTraceLevel() & 2) != 0) {
                trace.beginElement(PASSES_NODE_CONDITION, -1);
                trace.attribute(PASS, VALUE_TRUE);
                trace.attribute(REASON, reason);
                trace.endElement();
            }
        } else if ((trace.getTraceLevel() & 4) != 0) {
            trace.beginElement(PASSES_NODE_CONDITION, -1);
            trace.attribute(PASS, VALUE_FALSE);
            trace.attribute(REASON, reason);
            trace.endElement();
        }
    }

    public static final void traceExceptionMessage(Throwable t, XQETrace trace) {
        if (trace.getTraceLevel() != 0) {
            trace.beginElement(EXCEPTION_MESSAGE, -1);
            trace.data(t.getLocalizedMessage());
            trace.endElement();
        }
    }

    void setTransformationLibrary(AbstractRuleLibrary library) {
        this.mLibrary = library;
    }

    public AbstractRuleLibrary getTransformationLibrary() {
        return this.mLibrary;
    }

    private static void determineIfNamePreceededByLibraryName() {
        if (mDeterminedIfLibraryPreceedsName) {
            return;
        }
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.AURORA);
        if (configuration == null) {
            return;
        }
        boolean preceededByLibraryName = configuration.getBooleanProperty("transformations[@namePreceededByLibrary]", true);
        mPreceedNameByLibraryName = preceededByLibraryName;
    }

    protected void alignPassNumbersWithLibraryBasePassNumber(int startingPassNumber) {
        if (this.mSharedPassNumbers) {
            return;
        }
        for (int i = 0; i < this.mPassNumbers.length; ++i) {
            if (this.mPassNumbers[i] == -1) continue;
            this.mPassNumbers[i] = this.mPassNumbers[i] + startingPassNumber;
        }
    }

    public static enum ApplicableIterations {
        UNDEFINED,
        INITIAL,
        UNLIMITED;

    }

    public static enum Mode {
        UNDEFINED,
        TOP_DOWN,
        BOTTOM_UP,
        INDEXED;

    }
}

