/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.rules;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.inference.QTESharedPassNumbers;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class AbstractRuleLibrary {
    protected List<AbstractRule> transformations = new ArrayList<AbstractRule>();
    protected Properties mPassNames = new Properties();
    private final int mStartingPassNumber;
    private int mNumberOfPasses = 0;
    private List<QTESharedPassNumbers> mSharedPassNumberCollection;

    public String getPassName(int passNumber) {
        String defaultPassName = "[Pass " + passNumber + "]";
        return this.mPassNames.getProperty(String.valueOf(passNumber), defaultPassName);
    }

    protected int getStartingPassNumber() {
        return this.mStartingPassNumber;
    }

    public int getFinalPassNumber() {
        return this.mStartingPassNumber + this.mNumberOfPasses;
    }

    public void assignPassName(int relativePassNumber, String passName) {
        this.mPassNames.setProperty(String.valueOf(this.mStartingPassNumber + relativePassNumber), passName);
    }

    public String getLibraryName() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return name;
    }

    protected AbstractRule.Mode getTransformationMode() {
        return AbstractRule.Mode.INDEXED;
    }

    public AbstractRule.ApplicableIterations getApplicableIterations() {
        return AbstractRule.ApplicableIterations.UNLIMITED;
    }

    public AbstractRuleLibrary(int startingPassNumber, int numberOfPasses) {
        this.mStartingPassNumber = startingPassNumber;
        this.mNumberOfPasses = numberOfPasses + 1;
        this.addSharedPassNumberCollections();
        this.buildTransformationLibrary();
        this.resolveTransformationRules();
        this.assignLibraryToTransformationRules();
        this.alignPassNumbersWithLibrary();
    }

    private void alignPassNumbersWithLibrary() {
        for (AbstractRule aTransformation : this.transformations) {
            aTransformation.alignPassNumbersWithLibraryBasePassNumber(this.getStartingPassNumber());
        }
        if (this.mSharedPassNumberCollection == null) {
            return;
        }
        for (QTESharedPassNumbers passNumberCollection : this.mSharedPassNumberCollection) {
            passNumberCollection.alignPassNumbersWithLibraryBasePassNumber(this.getStartingPassNumber());
        }
    }

    protected abstract void buildTransformationLibrary();

    protected void addSharedPassNumberCollections() {
    }

    public void resolveTransformationRules() {
        for (AbstractRule aTransformation : this.transformations) {
            aTransformation.resolveApplicableIterations(this.getApplicableIterations());
            aTransformation.resolveMode(this.getTransformationMode());
        }
    }

    public List<AbstractRule> getTransformations() {
        return this.transformations;
    }

    private void assignLibraryToTransformationRules() {
        for (AbstractRule transformation : this.transformations) {
            transformation.setTransformationLibrary(this);
        }
    }

    public void addSharedPassNumberCollection(int identifier, int[] passNumbers) {
        if (this.mSharedPassNumberCollection == null) {
            this.mSharedPassNumberCollection = new ArrayList<QTESharedPassNumbers>();
        }
        QTESharedPassNumbers passNumberCollection = new QTESharedPassNumbers(passNumbers);
        this.mSharedPassNumberCollection.add(identifier, passNumberCollection);
    }

    public QTESharedPassNumbers getSharedPassNumberCollection(int identifier) {
        if (this.mSharedPassNumberCollection == null) {
            return null;
        }
        return this.mSharedPassNumberCollection.get(identifier);
    }

    public boolean passesCondition(IXQEQueryNode node, PlanningEnvironment environment, AbstractRule transformation) {
        return true;
    }
}

