/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.trace;

import com.ibm.cognos.aurora.core.expert.trace.IMemento;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLMemento
implements IMemento {
    private final Document factory;
    private final Element element;

    public static XMLMemento createReadRoot(Reader reader) throws ParserConfigurationException, SAXException, IOException {
        return XMLMemento.createReadRoot(reader, null);
    }

    public static XMLMemento createReadRoot(Reader reader, String baseDir) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        InputSource source = new InputSource(reader);
        if (baseDir != null) {
            source.setSystemId(baseDir);
        }
        parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        Document document = parser.parse(source);
        NodeList list = document.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            return new XMLMemento(document, (Element)node);
        }
        return null;
    }

    public static XMLMemento createWriteRoot(String type) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(type);
            document.appendChild(element);
            return new XMLMemento(document, element);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e.getMessage());
        }
    }

    public XMLMemento(Document document, Element element1) {
        this.factory = document;
        this.element = element1;
    }

    @Override
    public IMemento createChild(String type) {
        Element child = this.factory.createElement(type);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    @Override
    public IMemento createChild(String type, String id) {
        Element child = this.factory.createElement(type);
        if (id == null) {
            child.setAttribute("IMemento.internal.id", "");
        } else {
            child.setAttribute("IMemento.internal.id", id);
        }
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    public IMemento copyChild(IMemento child) {
        Element childElement = ((XMLMemento)child).element;
        Element newElement = (Element)this.factory.importNode(childElement, true);
        this.element.appendChild(newElement);
        return new XMLMemento(this.factory, newElement);
    }

    @Override
    public IMemento getChild(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        for (int nX = 0; nX < size; ++nX) {
            Element element1;
            Node node = nodes.item(nX);
            if (!(node instanceof Element) || !(element1 = (Element)node).getNodeName().equals(type)) continue;
            return new XMLMemento(this.factory, element1);
        }
        return null;
    }

    @Override
    public IMemento[] getChildren(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return new IMemento[0];
        }
        ArrayList<Element> list = new ArrayList<Element>(size);
        for (int nX = 0; nX < size; ++nX) {
            Element element1;
            Node node = nodes.item(nX);
            if (!(node instanceof Element) || !(element1 = (Element)node).getNodeName().equals(type)) continue;
            list.add(element1);
        }
        size = list.size();
        IMemento[] results = new IMemento[size];
        for (int x = 0; x < size; ++x) {
            results[x] = new XMLMemento(this.factory, (Element)list.get(x));
        }
        return results;
    }

    @Override
    public Float getFloat(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        return new Float(strValue);
    }

    @Override
    public String getType() {
        return this.element.getNodeName();
    }

    @Override
    public String getID() {
        return this.element.getAttribute("IMemento.internal.id");
    }

    @Override
    public Integer getInteger(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        return new Integer(strValue);
    }

    @Override
    public String getString(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    @Override
    public Boolean getBoolean(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        return Boolean.valueOf(attr.getValue());
    }

    @Override
    public String getTextData() {
        Text textNode = this.getTextNode();
        if (textNode != null) {
            return textNode.getData();
        }
        return null;
    }

    @Override
    public String[] getAttributeKeys() {
        NamedNodeMap map = this.element.getAttributes();
        int size = map.getLength();
        String[] attributes = new String[size];
        for (int i = 0; i < size; ++i) {
            Node node = map.item(i);
            attributes[i] = node.getNodeName();
        }
        return attributes;
    }

    private Text getTextNode() {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        for (int nX = 0; nX < size; ++nX) {
            Node node = nodes.item(nX);
            if (!(node instanceof Text)) continue;
            return (Text)node;
        }
        return null;
    }

    private void putElement(Element element1, boolean copyText) {
        NamedNodeMap nodeMap = element1.getAttributes();
        int size = nodeMap.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attr = (Attr)nodeMap.item(i);
            this.putString(attr.getName(), attr.getValue());
        }
        NodeList nodes = element1.getChildNodes();
        size = nodes.getLength();
        boolean needToCopyText = copyText;
        for (int i = 0; i < size; ++i) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                XMLMemento child = (XMLMemento)this.createChild(node.getNodeName());
                child.putElement((Element)node, true);
                continue;
            }
            if (!(node instanceof Text) || !needToCopyText) continue;
            this.putTextData(((Text)node).getData());
            needToCopyText = false;
        }
    }

    @Override
    public void putFloat(String key, float f) {
        this.element.setAttribute(key, String.valueOf(f));
    }

    @Override
    public void putInteger(String key, int n) {
        this.element.setAttribute(key, String.valueOf(n));
    }

    @Override
    public void putMemento(IMemento memento) {
        this.putElement(((XMLMemento)memento).element, false);
    }

    @Override
    public void putString(String key, String value) {
        if (value == null) {
            return;
        }
        this.element.setAttribute(key, value);
    }

    @Override
    public void putBoolean(String key, boolean value) {
        String attribute = value ? "true" : "false";
        this.element.setAttribute(key, attribute);
    }

    @Override
    public void putTextData(String data) {
        Text textNode = this.getTextNode();
        if (textNode == null) {
            textNode = this.factory.createTextNode(data);
            this.element.insertBefore(textNode, this.element.getFirstChild());
        } else {
            textNode.setData(data);
        }
    }

    public void save(Writer writer) throws IOException {
        DOMWriter out = new DOMWriter(writer);
        try {
            out.print(this.element);
        }
        finally {
            out.close();
        }
    }

    private static final class DOMWriter
    extends PrintWriter {
        private static final String END_TAG = ">";
        private static final int BUFFER_SIZE = 10;
        private static final int SPACE = 32;
        private static final int THIRTEEN = 13;
        private static final int TEN = 10;
        private static final int NINE = 9;
        private int tab = 0;
        private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

        public DOMWriter(Writer output) {
            super(output);
            this.println(XML_VERSION);
        }

        public void print(Element element) {
            boolean hasChildren = element.hasChildNodes();
            this.startTag(element, hasChildren);
            if (hasChildren) {
                ++this.tab;
                boolean prevWasText = false;
                NodeList children = element.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node instanceof Element) {
                        if (!prevWasText) {
                            this.println();
                            this.printTabulation();
                        }
                        this.print((Element)children.item(i));
                        prevWasText = false;
                        continue;
                    }
                    if (!(node instanceof Text)) continue;
                    this.print(DOMWriter.getEscaped(node.getNodeValue()));
                    prevWasText = true;
                }
                --this.tab;
                if (!prevWasText) {
                    this.println();
                    this.printTabulation();
                }
                this.endTag(element);
            }
        }

        private void printTabulation() {
        }

        private void startTag(Element element, boolean hasChildren) {
            StringBuffer sb = new StringBuffer();
            sb.append("<");
            sb.append(element.getTagName());
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                sb.append(" ");
                sb.append(attribute.getName());
                sb.append("=\"");
                sb.append(DOMWriter.getEscaped(String.valueOf(attribute.getValue())));
                sb.append("\"");
            }
            if (hasChildren) {
                sb.append(END_TAG);
            } else {
                sb.append("/>");
            }
            this.print(sb.toString());
        }

        private void endTag(Element element) {
            StringBuffer sb = new StringBuffer();
            sb.append("</");
            sb.append(element.getNodeName());
            sb.append(END_TAG);
            this.print(sb.toString());
        }

        private static void appendEscapedChar(StringBuffer buffer, char c) {
            String replacement = DOMWriter.getReplacement(c);
            if (replacement != null) {
                buffer.append('&');
                buffer.append(replacement);
                buffer.append(';');
            } else if (c == '\t' || c == '\n' || c == '\r' || c >= ' ') {
                buffer.append(c);
            }
        }

        private static String getEscaped(String s) {
            StringBuffer result = new StringBuffer(s.length() + 10);
            for (int i = 0; i < s.length(); ++i) {
                DOMWriter.appendEscapedChar(result, s.charAt(i));
            }
            return result.toString();
        }

        private static String getReplacement(char c) {
            switch (c) {
                case '<': {
                    return "lt";
                }
                case '>': {
                    return "gt";
                }
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '&': {
                    return "amp";
                }
                case '\r': {
                    return "#x0D";
                }
                case '\n': {
                    return "#x0A";
                }
                case '\t': {
                    return "#x09";
                }
            }
            return null;
        }
    }
}

