/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract;

import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.importer.importspec.EDocumentType;
import com.ibm.cognos.aurora.core.extract.CSVExtracter;
import com.ibm.cognos.aurora.core.extract.TabularExtracter;
import com.ibm.cognos.aurora.core.extract.XLSExtracter;
import com.ibm.cognos.aurora.core.extract.XLSXExtracter;
import com.ibm.cognos.aurora.core.extract.XMLExtracter;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public final class TabularExtracterFactory {
    public static TabularExtracter create(String originalFileName, EDocumentType docType) throws ImportException {
        return TabularExtracterFactory.create(originalFileName, new File(originalFileName), docType);
    }

    public static TabularExtracter create(String originalFileName, File localDataFile, EDocumentType docType) throws ImportException {
        if ((null == docType || EDocumentType.AUTO == docType) && null == (docType = TabularExtracterFactory.determineDocType(originalFileName))) {
            throw new ImportException("Unsupported document type: " + originalFileName);
        }
        switch (docType) {
            case CSV: {
                return new CSVExtracter(localDataFile);
            }
            case EXCEL97: {
                return new XLSExtracter(localDataFile);
            }
            case EXCEL07: {
                return new XLSXExtracter(localDataFile);
            }
            case XML: {
                return new XMLExtracter(localDataFile);
            }
        }
        throw new ImportException("Unsupported document type: " + originalFileName);
    }

    private static EDocumentType determineDocType(String fileName) {
        if (null == fileName || 0 == fileName.length()) {
            throw new IllegalArgumentException("File name was missing");
        }
        String extension = FilenameUtils.getExtension((String)fileName).toLowerCase();
        if (0 == extension.length()) {
            return null;
        }
        if ("csv".equals(extension) || "txt".equals(extension)) {
            return EDocumentType.CSV;
        }
        if ("xls".equals(extension)) {
            return EDocumentType.EXCEL97;
        }
        if ("xlsx".equals(extension)) {
            return EDocumentType.EXCEL07;
        }
        if ("xml".equals(extension)) {
            return EDocumentType.XML;
        }
        return null;
    }

    private TabularExtracterFactory() {
    }
}

