/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract;

import com.ibm.cognos.aurora.core.extract.parser.CurrencyParser;
import com.ibm.cognos.aurora.core.util.LCID;
import com.ibm.cognos.aurora.core.util.UniqueNameSet;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.util.HashSet;
import java.util.Set;

class XLSExtracterCommon {
    private static final double gDecimalThreshold = 1.0E-8;
    private UniqueNameSet mUniqueHeaders = new UniqueNameSet();

    XLSExtracterCommon() {
    }

    static boolean hasDecimalPortion(double d) {
        double diff = Math.abs(d - (double)((long)d));
        return diff > 1.0E-8;
    }

    static boolean hasDateFormatting(String formatString) {
        if (formatString == null || formatString.length() == 0) {
            return false;
        }
        return formatString.contains("yy") || formatString.contains("YY");
    }

    static boolean hasTimeFormatting(String formatString) {
        if (formatString == null || formatString.length() == 0) {
            return false;
        }
        return formatString.contains("h") || formatString.contains("H");
    }

    static boolean hasPercentFormatting(String formatString) {
        if (formatString == null || formatString.length() == 0) {
            return false;
        }
        return formatString.contains("%");
    }

    static boolean hasCurrencyFormatting(String formatString) {
        if (formatString == null || formatString.length() == 0) {
            return false;
        }
        return formatString.contains("$");
    }

    static boolean hasThousandsGroupedFormatting(String formatString) {
        if (formatString == null || formatString.length() == 0) {
            return false;
        }
        int commaPos = formatString.lastIndexOf(44);
        if (-1 == commaPos || 0 == commaPos || formatString.length() - 1 == commaPos) {
            return false;
        }
        char charBefore = formatString.charAt(commaPos - 1);
        char charAfter = formatString.charAt(commaPos + 1);
        return !('#' != charBefore && '0' != charBefore && '?' != charBefore || '#' != charAfter && '0' != charAfter && '?' != charAfter);
    }

    static Set<Currency> extractCurrenciesFromFormat(String formatString, ULocale defaultLocale) {
        HashSet<Currency> result = new HashSet<Currency>();
        Currency defaultCurrency = Currency.getInstance((ULocale)defaultLocale);
        int firstCurrencySymbolPos = formatString.indexOf(36);
        if (firstCurrencySymbolPos < 0) {
            throw new IllegalArgumentException("Not a currency format: " + formatString);
        }
        if ('#' == formatString.charAt(firstCurrencySymbolPos + 1)) {
            result.add(defaultCurrency);
        } else if (firstCurrencySymbolPos > 0 && '[' == formatString.charAt(firstCurrencySymbolPos - 1)) {
            int closingBracketPos = formatString.indexOf(93, firstCurrencySymbolPos);
            if (closingBracketPos < 0) {
                throw new RuntimeException("Malformed format string: " + formatString);
            }
            int dashPos = (formatString = formatString.substring(firstCurrencySymbolPos + 1, closingBracketPos)).indexOf(45);
            if (dashPos > 0) {
                Currency cur;
                ULocale locale;
                String currencyCodePart = formatString.substring(0, dashPos);
                String lcidPart = formatString.substring(dashPos + 1);
                if (lcidPart != null && lcidPart.length() > 0 && null != (locale = LCID.toLocale(Integer.parseInt(lcidPart, 16))) && null != (cur = Currency.getInstance((ULocale)locale))) {
                    result.add(cur);
                }
                if (result.isEmpty()) {
                    result.addAll(CurrencyParser.extractCurrencies(currencyCodePart));
                }
            } else {
                result.addAll(CurrencyParser.extractCurrencies(formatString));
            }
        }
        if (result.isEmpty()) {
            result.add(defaultCurrency);
        }
        return result;
    }

    String makeNameUnique(String name) {
        return this.mUniqueHeaders.insert(name);
    }

    void clearNames() {
        this.mUniqueHeaders.clear();
    }
}

