/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract;

import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.model.value.decor.IValueDecoration;
import com.ibm.cognos.aurora.api.model.value.decor.ValueDecorations;
import com.ibm.cognos.aurora.core.extract.ExtractionContext;
import com.ibm.cognos.aurora.core.extract.TabularDataset;
import com.ibm.cognos.aurora.core.extract.TabularDatasetAppender;
import com.ibm.cognos.aurora.core.extract.TabularExtracter;
import com.ibm.cognos.aurora.core.extract.XLSExtracterCommon;
import com.ibm.icu.util.Currency;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Date;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XLSXExtracter
extends TabularExtracter {
    private final String mSourceFilePath;
    private ExtractionContext mContext;
    private TabularDataset mCurrentDataet;
    private TabularDatasetAppender mCurrentAppender;
    private XLSExtracterCommon mHelper = new XLSExtracterCommon();

    public XLSXExtracter(String filename) {
        this.mSourceFilePath = filename;
    }

    public XLSXExtracter(File localDataFile) {
        this.mSourceFilePath = localDataFile.getPath();
    }

    @Override
    public void extractDatasets(ExtractionContext aContext) {
        aContext.setDataSourceType("Excel07File");
        this.mContext = aContext;
        OPCPackage pkg = null;
        try {
            pkg = OPCPackage.open((String)this.mSourceFilePath, (PackageAccess)PackageAccess.READ);
            XSSFReader xssfReader = new XSSFReader(pkg);
            SharedStringsTable sst = xssfReader.getSharedStringsTable();
            StylesTable st = xssfReader.getStylesTable();
            XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            while (iter.hasNext()) {
                InputStream inStream = iter.next();
                String nameSheet = iter.getSheetName();
                this.mCurrentDataet = aContext.createDataset(nameSheet, "WorkSheet");
                this.processSheet(st, sst, inStream);
                inStream.close();
            }
        }
        catch (Exception ex) {
            throw new ImportException((Throwable)ex);
        }
        finally {
            if (this.mCurrentAppender != null) {
                this.mCurrentAppender.close();
            }
            if (null != pkg) {
                try {
                    pkg.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void close() {
    }

    private void processSheet(StylesTable styles, SharedStringsTable strings, InputStream sheetInputStream) throws Exception {
        InputSource sheetSource = new InputSource(sheetInputStream);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxFactory.newSAXParser();
        XMLReader sheetParser = saxParser.getXMLReader();
        XlsxSheetHandler handler = new XlsxSheetHandler(styles, strings);
        sheetParser.setContentHandler(handler);
        sheetParser.parse(sheetSource);
    }

    private class XlsxSheetHandler
    extends DefaultHandler {
        private StylesTable mStylesTable;
        private SharedStringsTable mSharedStringsTable;
        private boolean mIsParsingValue;
        private StringBuilder mValue;
        private IValue[] mCurrentRow;
        private boolean mIsCurrFirstRow = false;
        private int mCurrRowIndex = -1;
        private int mCurrColIndex = -1;
        private EDataType mCurrDataType;
        private short mCurrFormatIndex;
        private String mCurrFormatString;

        public XlsxSheetHandler(StylesTable styles, SharedStringsTable strings) {
            this.mStylesTable = styles;
            this.mSharedStringsTable = strings;
            this.mValue = new StringBuilder();
            this.mCurrDataType = EDataType.eNumber;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("row".equals(name)) {
                this.mIsCurrFirstRow = this.mCurrRowIndex == -1;
                int nextRowIndex = Integer.parseInt(attributes.getValue("r"));
                if (!this.mIsCurrFirstRow) {
                    this.skipRowsIfNeeded(nextRowIndex);
                }
                this.mCurrRowIndex = nextRowIndex;
            } else if ("inlineStr".equals(name) || "v".equals(name)) {
                this.mIsParsingValue = true;
                this.mValue.setLength(0);
            } else if ("c".equals(name)) {
                this.mCurrColIndex = this.determineColumnIndex(attributes.getValue("r"));
                this.determineCurrValueInfo(attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if ("row".equals(name)) {
                if (!this.mIsCurrFirstRow) {
                    this.addRow();
                } else {
                    this.mIsCurrFirstRow = false;
                    this.mCurrentRow = new IValue[XLSXExtracter.this.mCurrentDataet.numColumns()];
                    XLSXExtracter.this.mCurrentAppender = XLSXExtracter.this.mCurrentDataet.openAppender();
                }
            } else if ("v".equals(name)) {
                IValue cellValue = this.getCellValue();
                if (this.mIsCurrFirstRow) {
                    this.addDataItem(cellValue.toString());
                } else {
                    this.recordDataPoint(cellValue);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mIsParsingValue) {
                this.mValue.append(ch, start, length);
            }
        }

        private int determineColumnIndex(String cellCoordinate) {
            int firstDigit = -1;
            for (int idx = 0; idx < cellCoordinate.length(); ++idx) {
                if (!Character.isDigit(cellCoordinate.charAt(idx))) continue;
                firstDigit = idx;
                break;
            }
            String colID = cellCoordinate.substring(0, firstDigit);
            int column = -1;
            for (int i = 0; i < colID.length(); ++i) {
                char c = colID.charAt(i);
                column = (column + 1) * 26 + c - 65;
            }
            return column;
        }

        private void determineCurrValueInfo(Attributes colAttributes) {
            this.mCurrDataType = EDataType.eNumber;
            this.mCurrFormatIndex = (short)-1;
            this.mCurrFormatString = null;
            String cellType = colAttributes.getValue("t");
            String cellStyleStr = colAttributes.getValue("s");
            if ("b".equals(cellType)) {
                this.mCurrDataType = EDataType.eBool;
            } else if ("e".equals(cellType)) {
                this.mCurrDataType = EDataType.eError;
            } else if ("inlineStr".equals(cellType)) {
                this.mCurrDataType = EDataType.eInlineStr;
            } else if ("s".equals(cellType)) {
                this.mCurrDataType = EDataType.eString;
            } else if ("str".equals(cellType)) {
                this.mCurrDataType = EDataType.eFormula;
            } else if (cellStyleStr != null) {
                int styleIndex = Integer.parseInt(cellStyleStr);
                XSSFCellStyle style = this.mStylesTable.getStyleAt(styleIndex);
                this.mCurrFormatIndex = style.getDataFormat();
                this.mCurrFormatString = style.getDataFormatString();
                if (this.mCurrFormatString == null) {
                    this.mCurrFormatString = BuiltinFormats.getBuiltinFormat((int)this.mCurrFormatIndex);
                }
            }
        }

        private IValue getCellValue() {
            String sValue = this.mValue.toString();
            IValue outValue = null;
            switch (this.mCurrDataType) {
                case eBool: {
                    outValue = ValueFactory.createBoolean((sValue.charAt(0) == '1' ? 1 : 0) != 0);
                    break;
                }
                case eFormula: {
                    double dValue = this.canBeTreatedAsNumber(sValue);
                    if (dValue != Double.NaN) {
                        outValue = XLSExtracterCommon.hasDecimalPortion(dValue) ? ValueFactory.createDouble((double)dValue) : ValueFactory.createLong((long)((long)dValue));
                        break;
                    }
                    outValue = ValueFactory.createString((String)sValue);
                    break;
                }
                case eInlineStr: {
                    XSSFRichTextString rts1 = new XSSFRichTextString(sValue);
                    outValue = ValueFactory.createString((String)rts1.toString());
                    break;
                }
                case eString: {
                    int idx = Integer.parseInt(sValue);
                    XSSFRichTextString rts2 = new XSSFRichTextString(this.mSharedStringsTable.getEntryAt(idx));
                    String cleanedValue = ExtractionContext.sanitizeDataText(rts2.toString());
                    outValue = XLSXExtracter.this.mContext.isNullValue(cleanedValue) ? ValueFactory.createString(null) : ValueFactory.createString((String)cleanedValue);
                    break;
                }
                case eNumber: {
                    outValue = this.makeValueForNumber(Double.parseDouble(sValue));
                    break;
                }
                case eError: {
                    outValue = null;
                    break;
                }
                default: {
                    System.out.println("****Unexpected cell type: " + (Object)((Object)this.mCurrDataType));
                    System.out.println("row#: " + this.mCurrRowIndex + "col#: " + this.mCurrColIndex);
                }
            }
            return outValue;
        }

        private IValue makeValueForNumber(double dValue) {
            TabularDataset.ColumnInfo colInfo = XLSXExtracter.this.mCurrentDataet.getColumn(this.mCurrColIndex);
            boolean isValidDate = HSSFDateUtil.isValidExcelDate((double)dValue);
            boolean hasDate = isValidDate && XLSExtracterCommon.hasDateFormatting(this.mCurrFormatString);
            boolean hasTime = isValidDate && XLSExtracterCommon.hasTimeFormatting(this.mCurrFormatString);
            Object value = null;
            if (hasDate) {
                value = hasTime ? ValueFactory.createTimestamp((Date)HSSFDateUtil.getJavaDate((double)dValue)) : ValueFactory.createDate((Date)HSSFDateUtil.getJavaDate((double)dValue));
            } else if (hasTime) {
                value = ValueFactory.createTime((Date)HSSFDateUtil.getJavaDate((double)dValue));
            } else if (XLSExtracterCommon.hasCurrencyFormatting(this.mCurrFormatString)) {
                BigDecimal bd = BigDecimal.valueOf(dValue);
                int wholeDigits = bd.precision() - bd.scale();
                int newPrecision = wholeDigits + 4;
                value = ValueFactory.createDecimal((BigDecimal)bd.round(new MathContext(newPrecision)));
                for (Currency curr : XLSExtracterCommon.extractCurrenciesFromFormat(this.mCurrFormatString, XLSXExtracter.this.mContext.getLocale())) {
                    colInfo.addValueDecoration((IValueDecoration)ValueDecorations.getCurrencyDecoration((Currency)curr));
                }
            } else {
                value = XLSExtracterCommon.hasDecimalPortion(dValue) ? ValueFactory.createDouble((double)dValue) : ValueFactory.createLong((long)((long)dValue));
                if (XLSExtracterCommon.hasPercentFormatting(this.mCurrFormatString)) {
                    colInfo.addValueDecoration((IValueDecoration)ValueDecorations.getPercentDecoration((char)'%'));
                }
            }
            if (value.getType().isNumeric() && XLSExtracterCommon.hasThousandsGroupedFormatting(this.mCurrFormatString)) {
                colInfo.addValueDecoration((IValueDecoration)ValueDecorations.geThousandsSeparatorDecoration((char)','));
            }
            return value;
        }

        private double canBeTreatedAsNumber(String value) {
            double out = Double.NaN;
            try {
                out = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return out;
        }

        private void addRow() {
            XLSXExtracter.this.mCurrentAppender.appendRow(this.mCurrentRow);
            for (int i = 0; i < this.mCurrentRow.length; ++i) {
                this.mCurrentRow[i] = null;
            }
        }

        private void skipRowsIfNeeded(int newRowIndex) {
            int rowsSkipped = newRowIndex - this.mCurrRowIndex;
            for (int i = 0; i < this.mCurrentRow.length; ++i) {
                this.mCurrentRow[i] = null;
            }
            while (rowsSkipped > 1) {
                XLSXExtracter.this.mCurrentAppender.appendRow(this.mCurrentRow);
                --rowsSkipped;
            }
        }

        private void recordDataPoint(IValue dataValue) {
            if (this.mCurrColIndex >= this.mCurrentRow.length) {
                throw new ImportException("The data format currently supported is limited to a single table per sheet, and the column heading must appear on the first row. Please check you dataset!");
            }
            this.mCurrentRow[this.mCurrColIndex] = dataValue;
        }

        private void addDataItem(String heading) {
            boolean firstColIdx = false;
            String uniqueHeading = null;
            for (int i = XLSXExtracter.this.mCurrentDataet.numColumns(); i < this.mCurrColIndex - 0; ++i) {
                uniqueHeading = XLSXExtracter.this.mHelper.makeNameUnique("Column");
                XLSXExtracter.this.mCurrentDataet.addColumn(uniqueHeading, (IDataType)DataTypes.getUnknownType());
            }
            heading = ExtractionContext.sanitizeLabelText(heading);
            uniqueHeading = XLSXExtracter.this.mHelper.makeNameUnique(heading);
            XLSXExtracter.this.mCurrentDataet.addColumn(uniqueHeading, (IDataType)DataTypes.getUnknownType());
        }
    }

    private static enum EDataType {
        eBool,
        eError,
        eFormula,
        eInlineStr,
        eNumber,
        eString;

    }
}

