/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.api;

public final class NoSuchArcException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final int mArcId;
    private final int mStartId;
    private final int mEndId;

    public NoSuchArcException(int arcId) {
        super(String.format("No such arc id: %d", arcId));
        this.mArcId = arcId;
        this.mEndId = -1;
        this.mStartId = -1;
    }

    public NoSuchArcException(int startId, int endId) {
        super(String.format("No such arc [%d => %d]", startId, endId));
        this.mArcId = -1;
        this.mStartId = startId;
        this.mEndId = endId;
    }

    public int getArcId() {
        return this.mArcId;
    }

    public int getStartId() {
        return this.mStartId;
    }

    public int getEndId() {
        return this.mEndId;
    }
}

