/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.api;

import com.ibm.cognos.aurora.core.graph.api.IVertex;
import com.ibm.cognos.aurora.core.util.collection.Filters;
import com.ibm.cognos.aurora.core.util.collection.IFilter;

public final class VertexFilters
extends Filters {
    public static IFilter<IVertex> allTrue() {
        return VertexFilters.allTrue(IVertex.class);
    }

    public static IFilter<IVertex> allFalse() {
        return VertexFilters.allFalse(IVertex.class);
    }

    public static IFilter<IVertex> hasId(final int vertexId) {
        return new IFilter<IVertex>(){

            @Override
            public boolean passes(IVertex v) {
                return v.getId() == vertexId;
            }
        };
    }

    public static IFilter<IVertex> hasLabel(final String ... labels) {
        return new IFilter<IVertex>(){

            @Override
            public boolean passes(IVertex v) {
                if (null == labels || labels.length == 0) {
                    return true;
                }
                String vLabel = v.getLabel();
                for (String label : labels) {
                    if (!(null == vLabel ? null == label : vLabel.equals(label))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static IFilter<IVertex> hasPropertyValue(final String propertyName, final Object propertyValue) {
        return new IFilter<IVertex>(){

            @Override
            public boolean passes(IVertex v) {
                Object value = v.getPropertyValue(propertyName);
                if (null == value) {
                    return null == propertyValue;
                }
                if (null == propertyValue) {
                    return false;
                }
                return value.equals(propertyValue);
            }
        };
    }

    public static IFilter<IVertex> hasNeighbor(final IVertex neighbor) {
        return new IFilter<IVertex>(){

            @Override
            public boolean passes(IVertex v) {
                for (IVertex n : v.neighbors()) {
                    if (!n.equals(neighbor)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static IFilter<IVertex> hasInNeighbor(final IVertex neighbor) {
        return new IFilter<IVertex>(){

            @Override
            public boolean passes(IVertex v) {
                for (IVertex n : v.inNeighbors()) {
                    if (!n.equals(neighbor)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static IFilter<IVertex> hasOutNeighbor(final IVertex neighbor) {
        return new IFilter<IVertex>(){

            @Override
            public boolean passes(IVertex v) {
                for (IVertex n : v.outNeighbors()) {
                    if (!n.equals(neighbor)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private VertexFilters() {
    }
}

