/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.impl;

import com.ibm.cognos.aurora.core.graph.api.ArcFilters;
import com.ibm.cognos.aurora.core.graph.api.IArc;
import com.ibm.cognos.aurora.core.graph.api.IGraph;
import com.ibm.cognos.aurora.core.graph.api.IGraphChangeListener;
import com.ibm.cognos.aurora.core.graph.api.IVertex;
import com.ibm.cognos.aurora.core.graph.api.IVertexIndex;
import com.ibm.cognos.aurora.core.graph.api.NoSuchArcException;
import com.ibm.cognos.aurora.core.graph.api.NoSuchVertexException;
import com.ibm.cognos.aurora.core.graph.api.VertexFilters;
import com.ibm.cognos.aurora.core.graph.api.action.ArcAddedAction;
import com.ibm.cognos.aurora.core.graph.api.action.ArcPropChangedAction;
import com.ibm.cognos.aurora.core.graph.api.action.ArcRemovedAction;
import com.ibm.cognos.aurora.core.graph.api.action.GraphPropChangedAction;
import com.ibm.cognos.aurora.core.graph.api.action.IGraphAction;
import com.ibm.cognos.aurora.core.graph.api.action.VertexAddedAction;
import com.ibm.cognos.aurora.core.graph.api.action.VertexPropChangedAction;
import com.ibm.cognos.aurora.core.graph.api.action.VertexRemovedAction;
import com.ibm.cognos.aurora.core.graph.impl.SubGraphArc;
import com.ibm.cognos.aurora.core.graph.impl.SubGraphVertex;
import com.ibm.cognos.aurora.core.graph.util.AbstractPropertyContainer;
import com.ibm.cognos.aurora.core.graph.util.IPropertyChangeListener;
import com.ibm.cognos.aurora.core.graph.util.IPropertyContainer;
import com.ibm.cognos.aurora.core.graph.util.WeakListenerList;
import com.ibm.cognos.aurora.core.util.collection.FilteringIterable;
import com.ibm.cognos.aurora.core.util.collection.Filters;
import com.ibm.cognos.aurora.core.util.collection.IFilter;
import com.ibm.cognos.aurora.core.util.collection.IMapper;
import com.ibm.cognos.aurora.core.util.collection.MappingIterable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class SubGraph
implements IGraph {
    private final IGraph mParentGraph;
    private final IGraphChangeListener mParentListener = new ParentGraphListener();
    private final Map<Integer, IVertex> mIdToVertexWrapperMap = new LinkedHashMap<Integer, IVertex>();
    private final IFilter<IVertex> mVertexFilter = new IFilter<IVertex>(){

        @Override
        public boolean passes(IVertex v) {
            return SubGraph.this.mIdToVertexWrapperMap.containsKey(v.getId());
        }
    };
    private final IMapper<IVertex, IVertex> mVertexMapper = new IMapper<IVertex, IVertex>(){

        @Override
        public IVertex map(IVertex v) {
            return (IVertex)SubGraph.this.mIdToVertexWrapperMap.get(v.getId());
        }
    };
    private final Map<Integer, IArc> mIdToArcWrapperMap = new LinkedHashMap<Integer, IArc>();
    private final IFilter<IArc> mArcFilter = new IFilter<IArc>(){

        @Override
        public boolean passes(IArc a) {
            return SubGraph.this.mIdToArcWrapperMap.containsKey(a.getId());
        }
    };
    private final IMapper<IArc, IArc> mArcMapper = new IMapper<IArc, IArc>(){

        @Override
        public IArc map(IArc a) {
            return (IArc)SubGraph.this.mIdToArcWrapperMap.get(a.getId());
        }
    };
    private final WeakListenerList<IPropertyChangeListener> mPropertyListeners = new WeakListenerList();
    private final WeakListenerList<IGraphChangeListener> mGraphListeners = new WeakListenerList();
    private int mCachedHashCode = 0;

    public SubGraph(IGraph parentGraph, Iterable<IVertex> vertices, Iterable<IArc> arcs) {
        this.mParentGraph = parentGraph;
        this.mParentGraph.addListener(this.mParentListener);
        for (IVertex v : vertices) {
            this.mIdToVertexWrapperMap.put(v.getId(), new SubGraphVertex(this, v));
        }
        for (IArc a : arcs) {
            if (!this.mIdToVertexWrapperMap.containsKey(a.getStart().getId())) {
                throw new IllegalArgumentException("arc start refers to non-existent vertex: " + a.getStart().getId());
            }
            if (!this.mIdToVertexWrapperMap.containsKey(a.getEnd().getId())) {
                throw new IllegalArgumentException("arc end refers to non-existent vertex: " + a.getStart().getId());
            }
            this.mIdToArcWrapperMap.put(a.getId(), new SubGraphArc(this, a));
        }
    }

    Iterable<IVertex> filterAndWrapVertices(Iterable<IVertex> vertices) {
        return new MappingIterable<IVertex, IVertex>(new FilteringIterable<IVertex>(vertices, this.mVertexFilter), this.mVertexMapper);
    }

    Iterable<IArc> filterAndWrapArcs(Iterable<IArc> arcs) {
        return new MappingIterable<IArc, IArc>(new FilteringIterable<IArc>(arcs, this.mArcFilter), this.mArcMapper);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.mParentGraph.getPropertyKeys();
    }

    @Override
    public boolean containsPropertyKey(String key) {
        return this.mParentGraph.containsPropertyKey(key);
    }

    @Override
    public Object getPropertyValue(String key) {
        return this.mParentGraph.getPropertyValue(key);
    }

    @Override
    public <T> T getPropertyValue(String key, Class<T> klass) {
        return this.mParentGraph.getPropertyValue(key, klass);
    }

    @Override
    public void setPropertyValue(String key, Object value) {
        this.mParentGraph.setPropertyValue(key, value);
    }

    @Override
    public void removeProperty(String key) {
        this.mParentGraph.removeProperty(key);
    }

    @Override
    public void copyFrom(IPropertyContainer source) {
        this.mParentGraph.copyFrom(source);
    }

    @Override
    public void copyTo(IPropertyContainer target) {
        this.mParentGraph.copyTo(target);
    }

    @Override
    public void clearProperties() {
        this.mParentGraph.clearProperties();
    }

    @Override
    public void addListener(IPropertyChangeListener listener) {
        this.mPropertyListeners.add(listener);
    }

    @Override
    public void removeListener(IPropertyChangeListener listener) {
        this.mPropertyListeners.remove(listener);
    }

    @Override
    public int numVertices() {
        return this.mIdToVertexWrapperMap.size();
    }

    @Override
    public int numArcs() {
        return this.mIdToArcWrapperMap.size();
    }

    @Override
    public Iterable<IVertex> vertices() {
        return this.filterAndWrapVertices(this.mParentGraph.vertices());
    }

    @Override
    public Iterable<IVertex> vertices(IFilter<IVertex> filter) {
        return this.filterAndWrapVertices(this.mParentGraph.vertices(filter));
    }

    @Override
    public IVertex getVertex(int vertexId) {
        IVertex wrapper = this.mIdToVertexWrapperMap.get(vertexId);
        if (null == wrapper) {
            throw new NoSuchVertexException(vertexId);
        }
        return wrapper;
    }

    @Override
    public IVertex newVertex() {
        SubGraphVertex wrapper = new SubGraphVertex(this, this.mParentGraph.newVertex());
        this.mIdToVertexWrapperMap.put(wrapper.getId(), wrapper);
        this.dispatchOnVertexAdded(wrapper);
        return wrapper;
    }

    @Override
    public void removeVertex(IVertex v) {
        this.removeVertex(v.getId());
    }

    @Override
    public void removeVertex(int vertexId) {
        if (!this.mIdToVertexWrapperMap.containsKey(vertexId)) {
            throw new NoSuchVertexException(vertexId);
        }
        this.mParentGraph.removeVertex(vertexId);
    }

    @Override
    public void removeVertices(IFilter<IVertex> filter) {
        this.mParentGraph.removeVertices(Filters.and(filter, this.mVertexFilter));
    }

    @Override
    public Iterable<IArc> arcs() {
        return this.filterAndWrapArcs(this.mParentGraph.arcs());
    }

    @Override
    public Iterable<IArc> arcs(IFilter<IArc> filter) {
        return this.filterAndWrapArcs(this.mParentGraph.arcs(filter));
    }

    @Override
    public IArc getArc(int arcId) {
        IArc wrapper = this.mIdToArcWrapperMap.get(arcId);
        if (null == wrapper) {
            throw new NoSuchArcException(arcId);
        }
        return wrapper;
    }

    @Override
    public IArc findArc(IVertex start, IVertex end) {
        Iterator<IArc> arcIter = this.findArcs(start, end).iterator();
        if (arcIter.hasNext()) {
            return arcIter.next();
        }
        return null;
    }

    @Override
    public Iterable<IArc> findArcs(IVertex start, IVertex end) {
        IVertex wrapperStart = this.getVertex(start.getId());
        IVertex wrapperEnd = this.getVertex(end.getId());
        return wrapperStart.outArcs(ArcFilters.hasEnd(wrapperEnd));
    }

    @Override
    public IArc findArc(int startId, int endId) {
        Iterator<IArc> arcIter = this.findArcs(startId, endId).iterator();
        if (arcIter.hasNext()) {
            return arcIter.next();
        }
        return null;
    }

    @Override
    public Iterable<IArc> findArcs(int startId, int endId) {
        IVertex wrappedStart = this.getVertex(startId);
        IVertex wrappedEnd = this.getVertex(endId);
        return wrappedStart.outArcs(ArcFilters.hasEnd(wrappedEnd));
    }

    @Override
    public IArc newArc(IVertex start, IVertex end) {
        return this.newArc(start.getId(), end.getId());
    }

    @Override
    public IArc newArc(int startId, int endId) {
        if (!this.mIdToVertexWrapperMap.containsKey(startId)) {
            throw new NoSuchVertexException(startId);
        }
        if (!this.mIdToVertexWrapperMap.containsKey(endId)) {
            throw new NoSuchVertexException(endId);
        }
        SubGraphArc wrapper = new SubGraphArc(this, this.mParentGraph.newArc(startId, endId));
        this.mIdToArcWrapperMap.put(wrapper.getId(), wrapper);
        this.dispatchOnArcAdded(wrapper);
        return wrapper;
    }

    @Override
    public void removeArc(IArc arc) {
        this.removeArc(arc.getId());
    }

    @Override
    public void removeArc(int arcId) {
        if (!this.mIdToArcWrapperMap.containsKey(arcId)) {
            throw new NoSuchArcException(arcId);
        }
        this.mParentGraph.removeArc(arcId);
    }

    public void removeArc(IVertex start, IVertex end) {
        this.removeArc(start.getId(), end.getId());
    }

    public void removeArc(int startId, int endId) {
        IArc wrapper = this.findArc(startId, endId);
        if (null == wrapper) {
            throw new NoSuchArcException(startId, endId);
        }
        this.removeArc(wrapper);
    }

    @Override
    public void removeArcs(IVertex start, IVertex end) {
        this.removeArcs(ArcFilters.connects(start, end));
    }

    @Override
    public void removeArcs(int startId, int endId) {
        this.removeArcs(ArcFilters.connects(startId, endId));
    }

    @Override
    public void clear() {
        this.clearProperties();
        this.removeArcs(ArcFilters.allTrue());
        this.removeVertices(VertexFilters.allTrue());
    }

    @Override
    public void removeArcs(IFilter<IArc> filter) {
        this.mParentGraph.removeArcs(Filters.and(filter, this.mArcFilter));
    }

    @Override
    public IGraph newSubGraph(Iterable<IVertex> vertices, Iterable<IArc> arcs) {
        return new SubGraph(this, vertices, arcs);
    }

    @Override
    public void addListener(IGraphChangeListener listener) {
        this.mGraphListeners.add(listener);
    }

    @Override
    public void removeListener(IGraphChangeListener listener) {
        this.mGraphListeners.remove(listener);
    }

    @Override
    public void redoAction(IGraphAction action) {
        switch (action.getType()) {
            case ARC_ADDED: {
                ArcAddedAction tmp = (ArcAddedAction)action;
                if (!this.mIdToVertexWrapperMap.containsKey(tmp.getStartId())) {
                    throw new NoSuchVertexException(tmp.getStartId());
                }
                if (!this.mIdToVertexWrapperMap.containsKey(tmp.getEndId())) {
                    throw new NoSuchVertexException(tmp.getEndId());
                }
                this.mParentGraph.redoAction(action);
                SubGraphArc wrapper = new SubGraphArc(this, this.mParentGraph.getArc(tmp.getArcId()));
                this.mIdToArcWrapperMap.put(wrapper.getId(), wrapper);
                this.dispatchOnArcAdded(wrapper);
                break;
            }
            case ARC_PROP_CHANGED: {
                ArcPropChangedAction tmp = (ArcPropChangedAction)action;
                IArc wrapper = this.getArc(tmp.getArcId());
                wrapper.setPropertyValue(tmp.getProperty(), tmp.getNewValue());
                break;
            }
            case ARC_REMOVED: {
                ArcRemovedAction tmp = (ArcRemovedAction)action;
                this.removeArc(tmp.getArcId());
                break;
            }
            case GRAPH_PROP_CHANGED: {
                GraphPropChangedAction tmp = (GraphPropChangedAction)action;
                this.setPropertyValue(tmp.getProperty(), tmp.getNewValue());
                break;
            }
            case VERTEX_ADDED: {
                VertexAddedAction tmp = (VertexAddedAction)action;
                this.mParentGraph.redoAction(action);
                SubGraphVertex wrapper = new SubGraphVertex(this, this.mParentGraph.getVertex(tmp.getVertexId()));
                this.mIdToVertexWrapperMap.put(wrapper.getId(), wrapper);
                this.dispatchOnVertexAdded(wrapper);
                break;
            }
            case VERTEX_PROP_CHANGED: {
                VertexPropChangedAction tmp = (VertexPropChangedAction)action;
                IVertex wrapper = this.getVertex(tmp.getVertexId());
                wrapper.setPropertyValue(tmp.getProperty(), tmp.getNewValue());
                break;
            }
            case VERTEX_REMOVED: {
                VertexRemovedAction tmp = (VertexRemovedAction)action;
                this.removeVertex(tmp.getVertexId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported event type: " + (Object)((Object)action.getType()));
            }
        }
    }

    @Override
    public void undoAction(IGraphAction action) {
        switch (action.getType()) {
            case ARC_ADDED: {
                ArcAddedAction tmp = (ArcAddedAction)action;
                this.removeArc(tmp.getArcId());
                break;
            }
            case ARC_PROP_CHANGED: {
                ArcPropChangedAction tmp = (ArcPropChangedAction)action;
                IArc wrapper = this.getArc(tmp.getArcId());
                wrapper.setPropertyValue(tmp.getProperty(), tmp.getOldValue());
                break;
            }
            case ARC_REMOVED: {
                ArcRemovedAction tmp = (ArcRemovedAction)action;
                if (!this.mIdToVertexWrapperMap.containsKey(tmp.getStartId())) {
                    throw new NoSuchVertexException(tmp.getStartId());
                }
                if (!this.mIdToVertexWrapperMap.containsKey(tmp.getEndId())) {
                    throw new NoSuchVertexException(tmp.getEndId());
                }
                this.mParentGraph.undoAction(action);
                SubGraphArc wrapper = new SubGraphArc(this, this.mParentGraph.getArc(tmp.getArcId()));
                this.mIdToArcWrapperMap.put(wrapper.getId(), wrapper);
                this.dispatchOnArcAdded(wrapper);
                tmp.getArcProperties().copyTo(wrapper);
                break;
            }
            case GRAPH_PROP_CHANGED: {
                GraphPropChangedAction tmp = (GraphPropChangedAction)action;
                this.setPropertyValue(tmp.getProperty(), tmp.getOldValue());
                break;
            }
            case VERTEX_ADDED: {
                VertexAddedAction tmp = (VertexAddedAction)action;
                this.removeVertex(tmp.getVertexId());
                break;
            }
            case VERTEX_PROP_CHANGED: {
                VertexPropChangedAction tmp = (VertexPropChangedAction)action;
                IVertex v = this.getVertex(tmp.getVertexId());
                v.setPropertyValue(tmp.getProperty(), tmp.getOldValue());
                break;
            }
            case VERTEX_REMOVED: {
                VertexRemovedAction tmp = (VertexRemovedAction)action;
                this.mParentGraph.undoAction(action);
                SubGraphVertex wrapper = new SubGraphVertex(this, this.mParentGraph.getVertex(tmp.getVertexId()));
                this.mIdToVertexWrapperMap.put(wrapper.getId(), wrapper);
                this.dispatchOnVertexAdded(wrapper);
                tmp.getVertexProperties().copyTo(wrapper);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported event type: " + (Object)((Object)action.getType()));
            }
        }
    }

    @Override
    public IVertexIndex getVertexIndex(String indexName) {
        return this.mParentGraph.getVertexIndex(indexName);
    }

    @Override
    public IVertexIndex createVertexIndex(String indexName, String propertyKey) {
        return this.mParentGraph.createVertexIndex(indexName, propertyKey);
    }

    @Override
    public void removeVertexIndex(String indexName) {
        this.mParentGraph.removeVertexIndex(indexName);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        tsb.append("numVertices", this.numVertices());
        tsb.append("numArcs", this.numArcs());
        for (String key : this.getPropertyKeys()) {
            Object value = this.getPropertyValue(key);
            if (null == value) continue;
            tsb.append(key, value);
        }
        return tsb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IGraph)) {
            return false;
        }
        IGraph other = (IGraph)o;
        if (!AbstractPropertyContainer.equals(this, other)) {
            return false;
        }
        if (this.numVertices() != other.numVertices()) {
            return false;
        }
        if (this.numArcs() != other.numArcs()) {
            return false;
        }
        Iterator<IVertex> vertexIter1 = this.vertices().iterator();
        Iterator<IVertex> vertexIter2 = other.vertices().iterator();
        while (vertexIter1.hasNext()) {
            if (vertexIter1.next().equals(vertexIter2.next())) continue;
            return false;
        }
        Iterator<IArc> arcIter1 = this.arcs().iterator();
        Iterator<IArc> arcIter2 = other.arcs().iterator();
        while (arcIter1.hasNext()) {
            if (arcIter1.next().equals(arcIter2.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (0 != this.mCachedHashCode) {
            return this.mCachedHashCode;
        }
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.appendSuper(super.hashCode());
        for (IVertex v : this.vertices()) {
            hcb.append((Object)v);
        }
        for (IArc arc : this.arcs()) {
            hcb.append((Object)arc);
        }
        this.mCachedHashCode = hcb.toHashCode();
        if (0 == this.mCachedHashCode) {
            this.mCachedHashCode = 1;
        }
        return this.mCachedHashCode;
    }

    protected void dispatchOnVertexAdded(final IVertex vertex) {
        WeakListenerList.IListenerDispatcher<IGraphChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IGraphChangeListener>(){

            @Override
            public void dispatch(IGraphChangeListener listener) {
                listener.onVertexAdded(vertex);
            }
        };
        this.mGraphListeners.dispatch(dispatcher);
    }

    protected void dispatchOnVertexRemoved(final IVertex vertex) {
        WeakListenerList.IListenerDispatcher<IGraphChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IGraphChangeListener>(){

            @Override
            public void dispatch(IGraphChangeListener listener) {
                listener.onVertexRemoved(vertex);
            }
        };
        this.mGraphListeners.dispatch(dispatcher);
    }

    protected void dispatchOnArcAdded(final IArc arc) {
        WeakListenerList.IListenerDispatcher<IGraphChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IGraphChangeListener>(){

            @Override
            public void dispatch(IGraphChangeListener listener) {
                listener.onArcAdded(arc);
            }
        };
        this.mGraphListeners.dispatch(dispatcher);
    }

    protected void dispatchOnArcRemoved(final IArc arc) {
        WeakListenerList.IListenerDispatcher<IGraphChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IGraphChangeListener>(){

            @Override
            public void dispatch(IGraphChangeListener listener) {
                listener.onArcRemoved(arc);
            }
        };
        this.mGraphListeners.dispatch(dispatcher);
    }

    protected void dispatchOnGraphPropertyChanged(final String property, final Object oldValue, final Object newValue) {
        WeakListenerList.IListenerDispatcher<IGraphChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IGraphChangeListener>(){

            @Override
            public void dispatch(IGraphChangeListener listener) {
                listener.onGraphPropertyChanged(SubGraph.this, property, oldValue, newValue);
            }
        };
        this.mGraphListeners.dispatch(dispatcher);
        WeakListenerList.IListenerDispatcher<IPropertyChangeListener> dispatcher2 = new WeakListenerList.IListenerDispatcher<IPropertyChangeListener>(){

            @Override
            public void dispatch(IPropertyChangeListener listener) {
                listener.onPropertyChanged(SubGraph.this, property, oldValue, newValue);
            }
        };
        this.mPropertyListeners.dispatch(dispatcher2);
    }

    protected void dispatchOnArcPropertyChanged(final IArc arc, final String property, final Object oldValue, final Object newValue) {
        WeakListenerList.IListenerDispatcher<IGraphChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IGraphChangeListener>(){

            @Override
            public void dispatch(IGraphChangeListener listener) {
                listener.onArcPropertyChanged(arc, property, oldValue, newValue);
            }
        };
        this.mGraphListeners.dispatch(dispatcher);
    }

    protected void dispatchOnVertexPropertyChanged(final IVertex vertex, final String property, final Object oldValue, final Object newValue) {
        WeakListenerList.IListenerDispatcher<IGraphChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IGraphChangeListener>(){

            @Override
            public void dispatch(IGraphChangeListener listener) {
                listener.onVertexPropertyChanged(vertex, property, oldValue, newValue);
            }
        };
        this.mGraphListeners.dispatch(dispatcher);
    }

    private final class ParentGraphListener
    implements IGraphChangeListener {
        private ParentGraphListener() {
        }

        @Override
        public void onVertexAdded(IVertex vertex) {
        }

        @Override
        public void onVertexRemoved(IVertex vertex) {
            IVertex wrapper = (IVertex)SubGraph.this.mIdToVertexWrapperMap.remove(vertex.getId());
            if (null != wrapper) {
                SubGraph.this.mCachedHashCode = 0;
                SubGraph.this.dispatchOnVertexRemoved(wrapper);
            }
        }

        @Override
        public void onVertexPropertyChanged(IVertex vertex, String property, Object oldValue, Object newValue) {
            IVertex wrapper = (IVertex)SubGraph.this.mIdToVertexWrapperMap.get(vertex.getId());
            if (null != wrapper) {
                SubGraph.this.mCachedHashCode = 0;
                ((SubGraphVertex)wrapper).dispatchOnPropertyChanged(property, oldValue, newValue);
                SubGraph.this.dispatchOnVertexPropertyChanged(wrapper, property, oldValue, newValue);
            }
        }

        @Override
        public void onArcAdded(IArc arc) {
        }

        @Override
        public void onArcRemoved(IArc arc) {
            IArc wrapper = (IArc)SubGraph.this.mIdToArcWrapperMap.remove(arc.getId());
            if (null != wrapper) {
                SubGraph.this.mCachedHashCode = 0;
                SubGraph.this.dispatchOnArcRemoved(wrapper);
            }
        }

        @Override
        public void onArcPropertyChanged(IArc arc, String property, Object oldValue, Object newValue) {
            IArc wrapper = (IArc)SubGraph.this.mIdToArcWrapperMap.get(arc.getId());
            if (null != wrapper) {
                SubGraph.this.mCachedHashCode = 0;
                ((SubGraphArc)wrapper).dispatchOnPropertyChanged(property, oldValue, newValue);
                SubGraph.this.dispatchOnArcPropertyChanged(wrapper, property, oldValue, newValue);
            }
        }

        @Override
        public void onGraphPropertyChanged(IGraph graph, String property, Object oldValue, Object newValue) {
            SubGraph.this.mCachedHashCode = 0;
            SubGraph.this.dispatchOnGraphPropertyChanged(property, oldValue, newValue);
        }
    }
}

