/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.impl;

import com.ibm.cognos.aurora.core.graph.api.IArc;
import com.ibm.cognos.aurora.core.graph.api.IGraph;
import com.ibm.cognos.aurora.core.graph.api.IVertex;
import com.ibm.cognos.aurora.core.graph.impl.SubGraph;
import com.ibm.cognos.aurora.core.graph.util.IPropertyChangeListener;
import com.ibm.cognos.aurora.core.graph.util.IPropertyContainer;
import com.ibm.cognos.aurora.core.graph.util.WeakListenerList;
import com.ibm.cognos.aurora.core.util.collection.IFilter;
import java.util.Set;

public class SubGraphVertex
implements IVertex {
    private final SubGraph mSubGraph;
    private final IVertex mParentVertex;
    private final WeakListenerList<IPropertyChangeListener> mPropertyListeners = new WeakListenerList();

    public SubGraphVertex(SubGraph subGraph, IVertex parentVertex) {
        this.mSubGraph = subGraph;
        this.mParentVertex = parentVertex;
    }

    IVertex getParentVertex() {
        return this.mParentVertex;
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.mParentVertex.getPropertyKeys();
    }

    @Override
    public boolean containsPropertyKey(String key) {
        return this.mParentVertex.containsPropertyKey(key);
    }

    @Override
    public Object getPropertyValue(String key) {
        return this.mParentVertex.getPropertyValue(key);
    }

    @Override
    public <T> T getPropertyValue(String key, Class<T> klass) {
        return this.mParentVertex.getPropertyValue(key, klass);
    }

    @Override
    public void setPropertyValue(String key, Object value) {
        this.mParentVertex.setPropertyValue(key, value);
    }

    @Override
    public void removeProperty(String key) {
        this.mParentVertex.removeProperty(key);
    }

    @Override
    public void copyFrom(IPropertyContainer source) {
        this.mParentVertex.copyFrom(source);
    }

    @Override
    public void copyTo(IPropertyContainer target) {
        this.mParentVertex.copyTo(target);
    }

    @Override
    public void clearProperties() {
        this.mParentVertex.clearProperties();
    }

    @Override
    public void addListener(IPropertyChangeListener listener) {
        this.mPropertyListeners.add(listener);
    }

    @Override
    public void removeListener(IPropertyChangeListener listener) {
        this.mPropertyListeners.remove(listener);
    }

    @Override
    public IGraph getGraph() {
        return this.mSubGraph;
    }

    @Override
    public int getId() {
        return this.mParentVertex.getId();
    }

    @Override
    public String getLabel() {
        return this.mParentVertex.getLabel();
    }

    @Override
    public void setLabel(String label) {
        this.mParentVertex.setLabel(label);
    }

    @Override
    public Iterable<IArc> arcs() {
        return this.mSubGraph.filterAndWrapArcs(this.mParentVertex.arcs());
    }

    @Override
    public Iterable<IArc> arcs(IFilter<IArc> filter) {
        return this.mSubGraph.filterAndWrapArcs(this.mParentVertex.arcs(filter));
    }

    @Override
    public Iterable<IArc> inArcs() {
        return this.mSubGraph.filterAndWrapArcs(this.mParentVertex.inArcs());
    }

    @Override
    public Iterable<IArc> inArcs(IFilter<IArc> filter) {
        return this.mSubGraph.filterAndWrapArcs(this.mParentVertex.inArcs(filter));
    }

    @Override
    public Iterable<IArc> outArcs() {
        return this.mSubGraph.filterAndWrapArcs(this.mParentVertex.outArcs());
    }

    @Override
    public Iterable<IArc> outArcs(IFilter<IArc> filter) {
        return this.mSubGraph.filterAndWrapArcs(this.mParentVertex.outArcs(filter));
    }

    @Override
    public Iterable<IVertex> neighbors() {
        return this.mSubGraph.filterAndWrapVertices(this.mParentVertex.neighbors());
    }

    @Override
    public Iterable<IVertex> neighbors(IFilter<IArc> arcFilter, IFilter<IVertex> vertexFilter) {
        return this.mSubGraph.filterAndWrapVertices(this.mParentVertex.neighbors(arcFilter, vertexFilter));
    }

    @Override
    public Iterable<IVertex> inNeighbors() {
        return this.mSubGraph.filterAndWrapVertices(this.mParentVertex.inNeighbors());
    }

    @Override
    public Iterable<IVertex> inNeighbors(IFilter<IArc> arcFilter, IFilter<IVertex> vertexFilter) {
        return this.mSubGraph.filterAndWrapVertices(this.mParentVertex.inNeighbors(arcFilter, vertexFilter));
    }

    @Override
    public Iterable<IVertex> outNeighbors() {
        return this.mSubGraph.filterAndWrapVertices(this.mParentVertex.outNeighbors());
    }

    @Override
    public Iterable<IVertex> outNeighbors(IFilter<IArc> arcFilter, IFilter<IVertex> vertexFilter) {
        return this.mSubGraph.filterAndWrapVertices(this.mParentVertex.outNeighbors(arcFilter, vertexFilter));
    }

    public boolean equals(Object o) {
        return this.mParentVertex.equals(o);
    }

    public int hashCode() {
        return this.mParentVertex.hashCode();
    }

    public String toString() {
        return this.mParentVertex.toString();
    }

    protected void dispatchOnPropertyChanged(final String property, final Object oldValue, final Object newValue) {
        WeakListenerList.IListenerDispatcher<IPropertyChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IPropertyChangeListener>(){

            @Override
            public void dispatch(IPropertyChangeListener listener) {
                listener.onPropertyChanged(SubGraphVertex.this, property, oldValue, newValue);
            }
        };
        this.mPropertyListeners.dispatch(dispatcher);
    }
}

