/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.impl.mem;

import com.ibm.cognos.aurora.core.graph.api.ArcFilters;
import com.ibm.cognos.aurora.core.graph.api.IArc;
import com.ibm.cognos.aurora.core.graph.api.IGraph;
import com.ibm.cognos.aurora.core.graph.api.IGraphChangeListener;
import com.ibm.cognos.aurora.core.graph.api.IVertex;
import com.ibm.cognos.aurora.core.graph.api.IVertexIndex;
import com.ibm.cognos.aurora.core.graph.api.NoSuchArcException;
import com.ibm.cognos.aurora.core.graph.api.NoSuchVertexException;
import com.ibm.cognos.aurora.core.graph.api.VertexFilters;
import com.ibm.cognos.aurora.core.graph.api.action.ArcAddedAction;
import com.ibm.cognos.aurora.core.graph.api.action.ArcPropChangedAction;
import com.ibm.cognos.aurora.core.graph.api.action.ArcRemovedAction;
import com.ibm.cognos.aurora.core.graph.api.action.GraphPropChangedAction;
import com.ibm.cognos.aurora.core.graph.api.action.IGraphAction;
import com.ibm.cognos.aurora.core.graph.api.action.VertexAddedAction;
import com.ibm.cognos.aurora.core.graph.api.action.VertexPropChangedAction;
import com.ibm.cognos.aurora.core.graph.api.action.VertexRemovedAction;
import com.ibm.cognos.aurora.core.graph.impl.SubGraph;
import com.ibm.cognos.aurora.core.graph.impl.mem.InMemoryArc;
import com.ibm.cognos.aurora.core.graph.impl.mem.InMemoryVertex;
import com.ibm.cognos.aurora.core.graph.impl.mem.InMemoryVertexIndex;
import com.ibm.cognos.aurora.core.graph.util.AbstractPropertyContainer;
import com.ibm.cognos.aurora.core.graph.util.IPropertyChangeListener;
import com.ibm.cognos.aurora.core.graph.util.MapPropertyContainer;
import com.ibm.cognos.aurora.core.graph.util.PropertyIndex;
import com.ibm.cognos.aurora.core.graph.util.WeakListenerList;
import com.ibm.cognos.aurora.core.util.collection.FilteringIterable;
import com.ibm.cognos.aurora.core.util.collection.IFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class InMemoryGraph
extends MapPropertyContainer
implements IGraph {
    public static final String PROP_NEXT_VERTEX_ID = "__nextVertexId";
    public static final String PROP_NEXT_ARC_ID = "__nextArcId";
    protected final PropertyIndex mVertexPropIndex = new PropertyIndex();
    protected final PropertyIndex mArcPropIndex = new PropertyIndex();
    private final Map<Integer, IVertex> mIdToVertexMap = new LinkedHashMap<Integer, IVertex>();
    private final Map<Integer, IArc> mIdToArcMap = new LinkedHashMap<Integer, IArc>();
    private final WeakListenerList<IGraphChangeListener> mGraphListeners = new WeakListenerList();
    private final IPropertyChangeListener mVertexPropListener = new VertexPropertyChangeAdapter();
    private final IPropertyChangeListener mArcPropListener = new ArcPropertyChangeAdapter();
    private final IPropertyChangeListener mGraphPropListener = new GraphPropertyChangeAdapter();
    private final IGraphChangeListener mClearHashCodeListener = new CachedHashCodeReseter();
    private final Map<String, IVertexIndex> mNamedVertexIndices = new HashMap<String, IVertexIndex>();
    private int mCachedHashCode = 0;

    public InMemoryGraph() {
        this.setPropertyValue(PROP_NEXT_VERTEX_ID, 0);
        this.setPropertyValue(PROP_NEXT_ARC_ID, 0);
        this.addListener(this.mGraphPropListener);
        this.addListener(this.mClearHashCodeListener);
    }

    protected int getAndIncrementNextVertexId() {
        int nextId = (Integer)this.getPropertyValue(PROP_NEXT_VERTEX_ID);
        this.setPropertyValue(PROP_NEXT_VERTEX_ID, nextId + 1);
        return nextId;
    }

    protected int getAndIncrementNextArcId() {
        int nextId = (Integer)this.getPropertyValue(PROP_NEXT_ARC_ID);
        this.setPropertyValue(PROP_NEXT_ARC_ID, nextId + 1);
        return nextId;
    }

    @Override
    public int numVertices() {
        return this.mIdToVertexMap.size();
    }

    @Override
    public int numArcs() {
        return this.mIdToArcMap.size();
    }

    @Override
    public Iterable<IVertex> vertices() {
        return this.mIdToVertexMap.values();
    }

    @Override
    public Iterable<IVertex> vertices(IFilter<IVertex> filter) {
        return new FilteringIterable<IVertex>(this.vertices(), filter);
    }

    @Override
    public IVertex getVertex(int vertexId) {
        IVertex v = this.mIdToVertexMap.get(vertexId);
        if (null == v) {
            throw new NoSuchVertexException(vertexId);
        }
        return v;
    }

    protected IVertex newVertex(int vertexId) {
        InMemoryVertex v = new InMemoryVertex(this, vertexId);
        v.addListener(this.mVertexPropListener);
        this.mIdToVertexMap.put(vertexId, v);
        this.dispatchOnVertexAdded(v);
        return v;
    }

    @Override
    public IVertex newVertex() {
        return this.newVertex(this.getAndIncrementNextVertexId());
    }

    @Override
    public void removeVertex(IVertex v) {
        this.removeVertex(v.getId());
    }

    @Override
    public void removeVertex(int vertexId) {
        InMemoryVertex v = (InMemoryVertex)this.mIdToVertexMap.remove(vertexId);
        if (null == v) {
            throw new NoSuchVertexException(vertexId);
        }
        for (IArc arc : v.inArcs()) {
            ((InMemoryVertex)arc.getStart()).removeOutArc((InMemoryArc)arc);
            this.mIdToArcMap.remove(arc.getId());
            this.dispatchOnArcRemoved(arc);
        }
        for (IArc arc : v.outArcs()) {
            ((InMemoryVertex)arc.getEnd()).removeInArc((InMemoryArc)arc);
            this.mIdToArcMap.remove(arc.getId());
            this.dispatchOnArcRemoved(arc);
        }
        v.removeListener(this.mVertexPropListener);
        v.clearArcs();
        this.dispatchOnVertexRemoved(v);
    }

    @Override
    public void removeVertices(IFilter<IVertex> filter) {
        LinkedList<IVertex> toRemove = new LinkedList<IVertex>();
        for (IVertex v : this.vertices(filter)) {
            toRemove.add(v);
        }
        for (IVertex v : toRemove) {
            this.removeVertex(v);
        }
    }

    @Override
    public IArc getArc(int arcId) {
        IArc arc = this.mIdToArcMap.get(arcId);
        if (null == arc) {
            throw new NoSuchArcException(arcId);
        }
        return arc;
    }

    @Override
    public Iterable<IArc> arcs() {
        return Collections.unmodifiableCollection(this.mIdToArcMap.values());
    }

    @Override
    public Iterable<IArc> arcs(IFilter<IArc> filter) {
        return new FilteringIterable<IArc>(this.arcs(), filter);
    }

    @Override
    public IArc findArc(IVertex start, IVertex end) {
        Iterator<IArc> arcIter = this.findArcs(start, end).iterator();
        if (arcIter.hasNext()) {
            return arcIter.next();
        }
        return null;
    }

    @Override
    public Iterable<IArc> findArcs(IVertex start, IVertex end) {
        return start.outArcs(ArcFilters.hasEnd(end));
    }

    @Override
    public IArc findArc(int startId, int endId) {
        return this.findArc(this.getVertex(startId), this.getVertex(endId));
    }

    @Override
    public Iterable<IArc> findArcs(int startId, int endId) {
        return this.findArcs(this.getVertex(startId), this.getVertex(endId));
    }

    protected IArc newArc(int arcId, IVertex start, IVertex end) {
        InMemoryArc arc = new InMemoryArc(this, arcId, start, end);
        arc.addListener(this.mArcPropListener);
        this.mIdToArcMap.put(arcId, arc);
        ((InMemoryVertex)start).addOutArc(arc);
        ((InMemoryVertex)end).addInArc(arc);
        this.dispatchOnArcAdded(arc);
        return arc;
    }

    @Override
    public IArc newArc(IVertex start, IVertex end) {
        return this.newArc(this.getAndIncrementNextArcId(), start, end);
    }

    protected IArc newArc(int arcId, int startId, int endId) {
        return this.newArc(arcId, this.getVertex(startId), this.getVertex(endId));
    }

    @Override
    public IArc newArc(int startId, int endId) {
        return this.newArc(this.getVertex(startId), this.getVertex(endId));
    }

    @Override
    public void removeArc(IArc arc) {
        this.removeArc(arc.getId());
    }

    @Override
    public void removeArc(int arcId) {
        InMemoryArc arc = (InMemoryArc)this.mIdToArcMap.remove(arcId);
        if (null == arc) {
            throw new NoSuchArcException(arcId);
        }
        arc.removeListener(this.mArcPropListener);
        ((InMemoryVertex)arc.getStart()).removeOutArc(arc);
        ((InMemoryVertex)arc.getEnd()).removeInArc(arc);
        this.dispatchOnArcRemoved(arc);
    }

    @Override
    public void removeArcs(IVertex start, IVertex end) {
        LinkedList<IArc> toRemove = new LinkedList<IArc>();
        for (IArc arc : this.findArcs(start, end)) {
            toRemove.add(arc);
        }
        for (IArc arc : toRemove) {
            this.removeArc(arc);
        }
    }

    @Override
    public void removeArcs(int startId, int endId) {
        LinkedList<IArc> toRemove = new LinkedList<IArc>();
        for (IArc arc : this.findArcs(startId, endId)) {
            toRemove.add(arc);
        }
        for (IArc arc : toRemove) {
            this.removeArc(arc);
        }
    }

    @Override
    public void removeArcs(IFilter<IArc> filter) {
        LinkedList<IArc> toRemove = new LinkedList<IArc>();
        for (IArc arc : this.arcs(filter)) {
            toRemove.add(arc);
        }
        for (IArc arc : toRemove) {
            this.removeArc(arc);
        }
    }

    @Override
    public void clear() {
        this.clearProperties();
        this.removeArcs(ArcFilters.allTrue());
        this.removeVertices(VertexFilters.allTrue());
    }

    @Override
    public final void addListener(IGraphChangeListener listener) {
        this.mGraphListeners.add(listener);
    }

    @Override
    public final void removeListener(IGraphChangeListener listener) {
        this.mGraphListeners.remove(listener);
    }

    @Override
    public void redoAction(IGraphAction action) {
        switch (action.getType()) {
            case ARC_ADDED: {
                ArcAddedAction tmp = (ArcAddedAction)action;
                this.newArc(tmp.getArcId(), tmp.getStartId(), tmp.getEndId());
                break;
            }
            case ARC_PROP_CHANGED: {
                ArcPropChangedAction tmp = (ArcPropChangedAction)action;
                IArc arc = this.getArc(tmp.getArcId());
                arc.setPropertyValue(tmp.getProperty(), tmp.getNewValue());
                break;
            }
            case ARC_REMOVED: {
                ArcRemovedAction tmp = (ArcRemovedAction)action;
                this.removeArc(tmp.getArcId());
                break;
            }
            case GRAPH_PROP_CHANGED: {
                GraphPropChangedAction tmp = (GraphPropChangedAction)action;
                this.setPropertyValue(tmp.getProperty(), tmp.getNewValue());
                break;
            }
            case VERTEX_ADDED: {
                VertexAddedAction tmp = (VertexAddedAction)action;
                this.newVertex(tmp.getVertexId());
                break;
            }
            case VERTEX_PROP_CHANGED: {
                VertexPropChangedAction tmp = (VertexPropChangedAction)action;
                IVertex v = this.getVertex(tmp.getVertexId());
                v.setPropertyValue(tmp.getProperty(), tmp.getNewValue());
                break;
            }
            case VERTEX_REMOVED: {
                VertexRemovedAction tmp = (VertexRemovedAction)action;
                this.removeVertex(tmp.getVertexId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported event type: " + (Object)((Object)action.getType()));
            }
        }
    }

    @Override
    public void undoAction(IGraphAction action) {
        switch (action.getType()) {
            case ARC_ADDED: {
                ArcAddedAction tmp = (ArcAddedAction)action;
                this.removeArc(tmp.getArcId());
                break;
            }
            case ARC_PROP_CHANGED: {
                ArcPropChangedAction tmp = (ArcPropChangedAction)action;
                IArc arc = this.getArc(tmp.getArcId());
                arc.setPropertyValue(tmp.getProperty(), tmp.getOldValue());
                break;
            }
            case ARC_REMOVED: {
                ArcRemovedAction tmp = (ArcRemovedAction)action;
                IArc arc = this.newArc(tmp.getArcId(), tmp.getStartId(), tmp.getEndId());
                tmp.getArcProperties().copyTo(arc);
                break;
            }
            case GRAPH_PROP_CHANGED: {
                GraphPropChangedAction tmp = (GraphPropChangedAction)action;
                this.setPropertyValue(tmp.getProperty(), tmp.getOldValue());
                break;
            }
            case VERTEX_ADDED: {
                VertexAddedAction tmp = (VertexAddedAction)action;
                this.removeVertex(tmp.getVertexId());
                break;
            }
            case VERTEX_PROP_CHANGED: {
                VertexPropChangedAction tmp = (VertexPropChangedAction)action;
                IVertex v = this.getVertex(tmp.getVertexId());
                v.setPropertyValue(tmp.getProperty(), tmp.getOldValue());
                break;
            }
            case VERTEX_REMOVED: {
                VertexRemovedAction tmp = (VertexRemovedAction)action;
                IVertex v = this.newVertex(tmp.getVertexId());
                tmp.getVertexProperties().copyTo(v);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported event type: " + (Object)((Object)action.getType()));
            }
        }
    }

    @Override
    public IGraph newSubGraph(Iterable<IVertex> vertices, Iterable<IArc> arcs) {
        return new SubGraph(this, vertices, arcs);
    }

    @Override
    public IVertexIndex getVertexIndex(String indexName) {
        return this.mNamedVertexIndices.get(indexName);
    }

    @Override
    public IVertexIndex createVertexIndex(String indexName, String propertyKey) {
        if (this.mNamedVertexIndices.containsKey(indexName)) {
            throw new IllegalArgumentException("Index already exists: " + indexName);
        }
        InMemoryVertexIndex index = new InMemoryVertexIndex(propertyKey);
        this.mNamedVertexIndices.put(indexName, index);
        for (IVertex v : this.vertices()) {
            index.insert(v);
        }
        this.addListener(index);
        return index;
    }

    @Override
    public void removeVertexIndex(String indexName) {
        IVertexIndex index = this.mNamedVertexIndices.remove(indexName);
        if (null != index) {
            this.removeListener(index);
        }
    }

    @Override
    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        tsb.append("numVertices", this.numVertices());
        tsb.append("numArcs", this.numArcs());
        for (String key : this.getPropertyKeys()) {
            Object value = this.getPropertyValue(key);
            if (null == value) continue;
            tsb.append(key, value);
        }
        return tsb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IGraph)) {
            return false;
        }
        IGraph other = (IGraph)o;
        if (!AbstractPropertyContainer.equals(this, other)) {
            return false;
        }
        if (this.numVertices() != other.numVertices()) {
            return false;
        }
        if (this.numArcs() != other.numArcs()) {
            return false;
        }
        Iterator<IVertex> vertexIter1 = this.vertices().iterator();
        Iterator<IVertex> vertexIter2 = other.vertices().iterator();
        while (vertexIter1.hasNext()) {
            if (vertexIter1.next().equals(vertexIter2.next())) continue;
            return false;
        }
        Iterator<IArc> arcIter1 = this.arcs().iterator();
        Iterator<IArc> arcIter2 = other.arcs().iterator();
        while (arcIter1.hasNext()) {
            if (arcIter1.next().equals(arcIter2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (0 != this.mCachedHashCode) {
            return this.mCachedHashCode;
        }
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.appendSuper(super.hashCode());
        for (IVertex v : this.vertices()) {
            hcb.append((Object)v);
        }
        for (IArc arc : this.arcs()) {
            hcb.append((Object)arc);
        }
        this.mCachedHashCode = hcb.toHashCode();
        if (0 == this.mCachedHashCode) {
            this.mCachedHashCode = 1;
        }
        return this.mCachedHashCode;
    }

    protected void dispatchOnVertexAdded(final IVertex vertex) {
        WeakListenerList.IListenerDispatcher<IGraphChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IGraphChangeListener>(){

            @Override
            public void dispatch(IGraphChangeListener listener) {
                listener.onVertexAdded(vertex);
            }
        };
        this.mGraphListeners.dispatch(dispatcher);
    }

    protected void dispatchOnVertexRemoved(final IVertex vertex) {
        WeakListenerList.IListenerDispatcher<IGraphChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IGraphChangeListener>(){

            @Override
            public void dispatch(IGraphChangeListener listener) {
                listener.onVertexRemoved(vertex);
            }
        };
        this.mGraphListeners.dispatch(dispatcher);
    }

    protected void dispatchOnArcAdded(final IArc arc) {
        WeakListenerList.IListenerDispatcher<IGraphChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IGraphChangeListener>(){

            @Override
            public void dispatch(IGraphChangeListener listener) {
                listener.onArcAdded(arc);
            }
        };
        this.mGraphListeners.dispatch(dispatcher);
    }

    protected void dispatchOnArcRemoved(final IArc arc) {
        WeakListenerList.IListenerDispatcher<IGraphChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IGraphChangeListener>(){

            @Override
            public void dispatch(IGraphChangeListener listener) {
                listener.onArcRemoved(arc);
            }
        };
        this.mGraphListeners.dispatch(dispatcher);
    }

    protected void dispatchOnGraphPropertyChanged(final String property, final Object oldValue, final Object newValue) {
        WeakListenerList.IListenerDispatcher<IGraphChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IGraphChangeListener>(){

            @Override
            public void dispatch(IGraphChangeListener listener) {
                listener.onGraphPropertyChanged(InMemoryGraph.this, property, oldValue, newValue);
            }
        };
        this.mGraphListeners.dispatch(dispatcher);
    }

    protected void dispatchOnArcPropertyChanged(final IArc arc, final String property, final Object oldValue, final Object newValue) {
        WeakListenerList.IListenerDispatcher<IGraphChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IGraphChangeListener>(){

            @Override
            public void dispatch(IGraphChangeListener listener) {
                listener.onArcPropertyChanged(arc, property, oldValue, newValue);
            }
        };
        this.mGraphListeners.dispatch(dispatcher);
    }

    protected void dispatchOnVertexPropertyChanged(final IVertex vertex, final String property, final Object oldValue, final Object newValue) {
        WeakListenerList.IListenerDispatcher<IGraphChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IGraphChangeListener>(){

            @Override
            public void dispatch(IGraphChangeListener listener) {
                listener.onVertexPropertyChanged(vertex, property, oldValue, newValue);
            }
        };
        this.mGraphListeners.dispatch(dispatcher);
    }

    private final class CachedHashCodeReseter
    implements IGraphChangeListener {
        private CachedHashCodeReseter() {
        }

        @Override
        public void onVertexAdded(IVertex vertex) {
            InMemoryGraph.this.mCachedHashCode = 0;
        }

        @Override
        public void onVertexRemoved(IVertex vertex) {
            InMemoryGraph.this.mCachedHashCode = 0;
        }

        @Override
        public void onVertexPropertyChanged(IVertex vertex, String property, Object oldValue, Object newValue) {
            InMemoryGraph.this.mCachedHashCode = 0;
        }

        @Override
        public void onArcAdded(IArc arc) {
            InMemoryGraph.this.mCachedHashCode = 0;
        }

        @Override
        public void onArcRemoved(IArc arc) {
            InMemoryGraph.this.mCachedHashCode = 0;
        }

        @Override
        public void onArcPropertyChanged(IArc arc, String property, Object oldValue, Object newValue) {
            InMemoryGraph.this.mCachedHashCode = 0;
        }

        @Override
        public void onGraphPropertyChanged(IGraph graph, String property, Object oldValue, Object newValue) {
            InMemoryGraph.this.mCachedHashCode = 0;
        }
    }

    private final class ArcPropertyChangeAdapter
    implements IPropertyChangeListener {
        private ArcPropertyChangeAdapter() {
        }

        @Override
        public void onPropertyChanged(Object target, String property, Object oldValue, Object newValue) {
            IArc arc = (IArc)target;
            InMemoryGraph.this.dispatchOnArcPropertyChanged(arc, property, oldValue, newValue);
        }
    }

    private final class VertexPropertyChangeAdapter
    implements IPropertyChangeListener {
        private VertexPropertyChangeAdapter() {
        }

        @Override
        public void onPropertyChanged(Object target, String property, Object oldValue, Object newValue) {
            IVertex vertex = (IVertex)target;
            InMemoryGraph.this.dispatchOnVertexPropertyChanged(vertex, property, oldValue, newValue);
        }
    }

    private final class GraphPropertyChangeAdapter
    implements IPropertyChangeListener {
        private GraphPropertyChangeAdapter() {
        }

        @Override
        public void onPropertyChanged(Object target, String property, Object oldValue, Object newValue) {
            InMemoryGraph.this.dispatchOnGraphPropertyChanged(property, oldValue, newValue);
        }
    }
}

