/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.persist.bin;

import com.ibm.cognos.aurora.core.graph.api.IArc;
import com.ibm.cognos.aurora.core.graph.api.IGraph;
import com.ibm.cognos.aurora.core.graph.api.IVertex;
import com.ibm.cognos.aurora.core.graph.persist.IGraphWriter;
import com.ibm.cognos.aurora.core.graph.persist.bin.BinaryValueSerializer;
import com.ibm.cognos.aurora.core.graph.util.IPropertyContainer;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;

public class BinaryGraphWriter
implements IGraphWriter {
    private final DataOutput mOutput;
    private final BinaryValueSerializer mValueSerializer;

    public BinaryGraphWriter(OutputStream out) {
        this.mOutput = new DataOutputStream(out);
        this.mValueSerializer = new BinaryValueSerializer();
    }

    public BinaryGraphWriter(DataOutput out) {
        this.mOutput = out;
        this.mValueSerializer = new BinaryValueSerializer();
    }

    public BinaryGraphWriter(OutputStream out, BinaryValueSerializer valueSerializer) {
        this.mOutput = new DataOutputStream(out);
        this.mValueSerializer = valueSerializer;
    }

    public BinaryGraphWriter(DataOutput out, BinaryValueSerializer valueSerializer) {
        this.mOutput = out;
        this.mValueSerializer = valueSerializer;
    }

    @Override
    public void writeGraph(IGraph graph) throws IOException {
        EncodeUtil.writeCompressedInt(this.mOutput, graph.numVertices());
        EncodeUtil.writeCompressedInt(this.mOutput, graph.numArcs());
        this.writePropertyContainer(graph);
        for (IVertex vertex : graph.vertices()) {
            this.mOutput.writeInt(vertex.getId());
            this.writePropertyContainer(vertex);
        }
        for (IArc arc : graph.arcs()) {
            this.mOutput.writeInt(arc.getId());
            this.mOutput.writeInt(arc.getStart().getId());
            this.mOutput.writeInt(arc.getEnd().getId());
            this.writePropertyContainer(arc);
        }
    }

    private void writePropertyContainer(IPropertyContainer container) throws IOException {
        Set<String> keys = container.getPropertyKeys();
        EncodeUtil.writeCompressedInt(this.mOutput, keys.size());
        for (String key : keys) {
            EncodeUtil.writeString(this.mOutput, key);
            this.mValueSerializer.writeValue(this.mOutput, container.getPropertyValue(key));
        }
    }
}

