/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.util;

import com.ibm.cognos.aurora.core.graph.util.IPropertyChangeListener;
import com.ibm.cognos.aurora.core.graph.util.IPropertyContainer;
import com.ibm.cognos.aurora.core.graph.util.WeakListenerList;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public abstract class AbstractPropertyContainer
implements IPropertyContainer {
    private final WeakListenerList<IPropertyChangeListener> mListeners = new WeakListenerList();

    @Override
    public <T> T getPropertyValue(String key, Class<T> klass) {
        return klass.cast(this.getPropertyValue(key));
    }

    @Override
    public void copyFrom(IPropertyContainer source) {
        for (String key : source.getPropertyKeys()) {
            this.setPropertyValue(key, source.getPropertyValue(key));
        }
    }

    @Override
    public void copyTo(IPropertyContainer target) {
        for (String key : this.getPropertyKeys()) {
            target.setPropertyValue(key, this.getPropertyValue(key));
        }
    }

    @Override
    public void addListener(IPropertyChangeListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void removeListener(IPropertyChangeListener listener) {
        this.mListeners.remove(listener);
    }

    protected final void dispatchOnPropertyChanged(final String property, final Object newValue, final Object oldValue) {
        WeakListenerList.IListenerDispatcher<IPropertyChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IPropertyChangeListener>(){

            @Override
            public void dispatch(IPropertyChangeListener listener) {
                listener.onPropertyChanged(AbstractPropertyContainer.this, property, oldValue, newValue);
            }
        };
        this.mListeners.dispatch(dispatcher);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(null, ToStringStyle.DEFAULT_STYLE);
        for (String key : this.getPropertyKeys()) {
            tsb.append(key, this.getPropertyValue(key));
        }
        return tsb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IPropertyContainer)) {
            return false;
        }
        IPropertyContainer other = (IPropertyContainer)o;
        return AbstractPropertyContainer.equals(this, other);
    }

    public int hashCode() {
        return AbstractPropertyContainer.hashCode(this);
    }

    public static int hashCode(IPropertyContainer container) {
        HashCodeBuilder hcb = new HashCodeBuilder();
        for (String key : container.getPropertyKeys()) {
            hcb.append((Object)key);
            hcb.append(container.getPropertyValue(key));
        }
        return hcb.toHashCode();
    }

    public static boolean equals(IPropertyContainer left, IPropertyContainer right) {
        Set<String> propKeys = left.getPropertyKeys();
        if (!propKeys.equals(right.getPropertyKeys())) {
            return false;
        }
        for (String key : propKeys) {
            Object leftValue = left.getPropertyValue(key);
            Object rightValue = right.getPropertyValue(key);
            if (null == leftValue) {
                if (null == rightValue) continue;
                return false;
            }
            if (null == rightValue) {
                return false;
            }
            if (leftValue == rightValue || leftValue.equals(rightValue)) continue;
            return false;
        }
        return true;
    }
}

