/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.util;

import com.ibm.cognos.aurora.core.graph.api.IGraph;
import com.ibm.cognos.aurora.core.graph.api.IVertex;
import com.ibm.cognos.aurora.core.graph.util.IWeightFunction;
import com.ibm.cognos.aurora.core.graph.util.PredecessorMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import org.apache.commons.lang.mutable.MutableInt;

public final class Dijkstra {
    public static void compute(IGraph graph, IVertex source, IWeightFunction weightFunc, EDirection edgeDirection, PredecessorMap predecessors) {
        final HashMap<IVertex, MutableInt> dist = new HashMap<IVertex, MutableInt>(graph.numVertices());
        Comparator<IVertex> comp = new Comparator<IVertex>(){

            @Override
            public int compare(IVertex v1, IVertex v2) {
                int w2;
                int w1 = ((MutableInt)dist.get(v1)).intValue();
                if (w1 < (w2 = ((MutableInt)dist.get(v2)).intValue())) {
                    return -1;
                }
                if (w1 > w2) {
                    return 1;
                }
                return 0;
            }
        };
        PriorityQueue<IVertex> queue = new PriorityQueue<IVertex>(graph.numVertices(), comp);
        for (IVertex v : graph.vertices()) {
            dist.put(v, new MutableInt(Integer.MAX_VALUE));
        }
        ((MutableInt)dist.get(source)).setValue(0);
        queue.add(source);
        predecessors.clear();
        while (!queue.isEmpty()) {
            IVertex u = queue.poll();
            int distToU = ((MutableInt)dist.get(u)).intValue();
            for (IVertex v : Dijkstra.neighbors(u, edgeDirection)) {
                MutableInt distToV = (MutableInt)dist.get(v);
                int distThroughU = distToU + weightFunc.weight(u, v);
                if (distThroughU >= distToV.intValue()) continue;
                distToV.setValue(distThroughU);
                predecessors.put(v, u);
                queue.add(v);
            }
        }
    }

    private static Iterable<IVertex> neighbors(IVertex v, EDirection edgeDirection) {
        switch (edgeDirection) {
            case IN: {
                return v.inNeighbors();
            }
            case OUT: {
                return v.outNeighbors();
            }
        }
        return v.neighbors();
    }

    private Dijkstra() {
    }

    public static enum EDirection {
        IN,
        OUT,
        BOTH;

    }
}

