/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.util;

import com.ibm.cognos.aurora.core.graph.util.AbstractPropertyContainer;
import com.ibm.cognos.aurora.core.graph.util.PropertyIndex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IndexedPropertyContainer
extends AbstractPropertyContainer {
    private final PropertyIndex mIndex;
    private final List<Object> mValues;

    public IndexedPropertyContainer(PropertyIndex index) {
        this.mIndex = index;
        this.mValues = new ArrayList<Object>(this.mIndex.numKeys());
    }

    @Override
    public Set<String> getPropertyKeys() {
        Set<String> fullKeySet = this.mIndex.getKeys();
        HashSet<String> populatedKeySet = new HashSet<String>(fullKeySet.size());
        for (String key : fullKeySet) {
            short keyId = this.mIndex.getKeyId(key);
            if (this.mValues.size() <= keyId || null == this.mValues.get(keyId)) continue;
            populatedKeySet.add(key);
        }
        return populatedKeySet;
    }

    @Override
    public boolean containsPropertyKey(String key) {
        return this.mIndex.containsKey(key);
    }

    @Override
    public Object getPropertyValue(String key) {
        Short id = this.mIndex.getKeyId(key);
        if (null == id) {
            return null;
        }
        if (this.mValues.size() <= id.intValue()) {
            return null;
        }
        return this.mValues.get(id.intValue());
    }

    @Override
    public void setPropertyValue(String key, Object value) {
        Short id = this.mIndex.getOrCreateKeyId(key);
        while (id.intValue() >= this.mValues.size()) {
            this.mValues.add(null);
        }
        Object oldValue = this.mValues.get(id.intValue());
        this.mValues.set(id.intValue(), value);
        this.dispatchOnPropertyChanged(key, value, oldValue);
    }

    @Override
    public void removeProperty(String key) {
        Short id = this.mIndex.getKeyId(key);
        if (null == id) {
            return;
        }
        if (id.intValue() >= this.mValues.size()) {
            return;
        }
        Object oldValue = this.mValues.set(id.intValue(), null);
        this.dispatchOnPropertyChanged(key, null, oldValue);
    }

    @Override
    public void clearProperties() {
        this.mValues.clear();
    }
}

