/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.util;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

public class WeakListenerList<L> {
    private final ConcurrentLinkedQueue<WeakReference<L>> mListenerRefs = new ConcurrentLinkedQueue();

    private void cleanupClearedRefs() {
        Iterator<WeakReference<L>> refIter = this.mListenerRefs.iterator();
        while (refIter.hasNext()) {
            if (refIter.next().get() != null) continue;
            refIter.remove();
        }
    }

    public void add(L listener) {
        this.cleanupClearedRefs();
        this.mListenerRefs.add(new WeakReference<L>(listener));
    }

    public void remove(L listener) {
        Iterator<WeakReference<L>> refIter = this.mListenerRefs.iterator();
        while (refIter.hasNext()) {
            Object elem = refIter.next().get();
            if (elem == null) {
                refIter.remove();
                continue;
            }
            if (elem != listener) continue;
            refIter.remove();
            return;
        }
    }

    public void clear() {
        this.mListenerRefs.clear();
    }

    public void dispatch(IListenerDispatcher<L> dispatcher) {
        Iterator<WeakReference<L>> refIter = this.mListenerRefs.iterator();
        while (refIter.hasNext()) {
            Object elem = refIter.next().get();
            if (elem == null) {
                refIter.remove();
                continue;
            }
            dispatcher.dispatch(elem);
        }
    }

    public static interface IListenerDispatcher<L> {
        public void dispatch(L var1);
    }
}

