/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer byteBuffer;
    private boolean closed = false;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.byteBuffer = buffer;
    }

    @Override
    public int read() throws IOException {
        if (this.closed || this.byteBuffer == null || !this.byteBuffer.hasRemaining()) {
            return -1;
        }
        return this.byteBuffer.get();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        if (this.closed || buffer == null) {
            return -1;
        }
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.closed || this.byteBuffer == null || !this.byteBuffer.hasRemaining()) {
            return -1;
        }
        int len = Math.min(length, this.byteBuffer.remaining());
        this.byteBuffer.get(buffer, offset, len);
        return len;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        super.close();
    }
}

