/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.logging;

import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.ILoggerFactory;
import com.ibm.cognos.aurora.core.logging.LoggingConfiguration;
import com.ibm.cognos.aurora.core.logging.log4j.Log4jLoggerFactory;
import com.ibm.cognos.aurora.core.logging.noop.NoOpLoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LoggerManager {
    private static final LoggerFactoryMapper m_mapper = new LoggerFactoryMapper();
    private static final Map<String, ILogger> repository = new HashMap<String, ILogger>();

    private LoggerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILogger getLogger(String name) {
        ILogger log = repository.get(name);
        if (null == log) {
            Map<String, ILogger> map = repository;
            synchronized (map) {
                log = repository.get(name);
                if (null == log) {
                    log = m_mapper.getLoggerFactory().makeNewLoggerInstance(name);
                    repository.put(name, log);
                }
            }
        }
        return log;
    }

    private static class LoggerFactoryMapper {
        private static ILoggerFactory mLoggerfactory = null;
        private static final String LOGGER_FACTORY_NAME = "athena.loggerFactory";

        private LoggerFactoryMapper() {
            try {
                Properties props = LoggingConfiguration.getProperties();
                String factoryClassName = props.getProperty(LOGGER_FACTORY_NAME);
                Class<?> newClass = Class.forName(factoryClassName);
                mLoggerfactory = (ILoggerFactory)newClass.newInstance();
            }
            catch (Exception ex) {
                System.out.println(ex.getLocalizedMessage() + " Try to use Log4jLoggerFactory");
                try {
                    Class<?> newClass = Class.forName(Log4jLoggerFactory.class.getName());
                    mLoggerfactory = (ILoggerFactory)newClass.newInstance();
                }
                catch (Exception e) {
                    System.out.println(e.getLocalizedMessage() + " Unable to use Log4jLoggerFactory. Use default NoOpLogFactory");
                    mLoggerfactory = new NoOpLoggerFactory();
                }
            }
        }

        public ILoggerFactory getLoggerFactory() {
            return mLoggerfactory;
        }
    }
}

