/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.logging.log4j;

import com.ibm.cognos.aurora.core.logging.AbstractLogger;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LogAction;
import com.ibm.cognos.aurora.core.logging.LogEventHelper;
import com.ibm.cognos.aurora.core.logging.event.AuditLogBaseEvent;
import com.ibm.cognos.aurora.core.logging.event.AuditLogEvent;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.aurora.core.logging.log4j.Log4jPerfLogEvent;
import com.ibm.cognos.aurora.core.logging.log4j.ResourceCounterSet;
import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jLogger
extends AbstractLogger
implements ILogger,
Serializable {
    private Logger traceLogger = null;
    private Logger auditLogger = null;
    private Logger perfLogger = null;
    private static final long serialVersionUID = 3866752473115466369L;

    @Override
    protected Logger getTraceLogger() {
        return this.traceLogger;
    }

    protected void setTraceLogger(Logger traceLogger) {
        this.traceLogger = traceLogger;
    }

    @Override
    protected Logger getAuditLogger() {
        return this.auditLogger;
    }

    protected void setAuditLogger(Logger auditLogger) {
        this.auditLogger = auditLogger;
    }

    @Override
    protected Logger getPerfLogger() {
        return this.perfLogger;
    }

    protected void setPerfLogger(Logger perfLogger) {
        this.perfLogger = perfLogger;
    }

    @Override
    public void auditSystemEvent(AuditLogEvent event) {
        if (this.isAuditSystemEventEnabled() && event != null) {
            this.auditLogger.log((Priority)Level.FATAL, (Object)event);
        }
    }

    @Override
    public void auditRequestEvent(AuditLogEvent event) {
        if (this.isAuditRequestEventEnabled() && event != null) {
            this.auditLogger.log((Priority)Level.WARN, (Object)event);
        }
    }

    @Override
    public void auditInfoEvent(AuditLogBaseEvent event) {
        if (this.isAuditInfoEventEnabled() && event != null) {
            this.auditLogger.log((Priority)Level.INFO, (Object)event);
        }
    }

    @Override
    public void auditDebugEvent(AuditLogBaseEvent event) {
        if (this.isAuditDebugEventEnabled() && event != null) {
            this.auditLogger.log((Priority)Level.DEBUG, (Object)event);
        }
    }

    @Override
    public void fatal(AuditLogEvent event) {
        this.auditSystemEvent(event);
        if (this.isFatalEnabled() && event != null) {
            this.traceLogger.log((Priority)Level.FATAL, (Object)LogEventHelper.createTraceLogEvent(event, Level.FATAL));
        }
    }

    @Override
    public void fatal(String errorMessage, String tracedObject) {
        this.auditSystemEvent(LogEventHelper.createAuditLogEvent4Error(errorMessage, tracedObject));
        if (this.isFatalEnabled()) {
            this.traceLogger.log((Priority)Level.FATAL, (Object)LogEventHelper.createTraceLogEvent(errorMessage, tracedObject, Level.FATAL));
        }
    }

    @Override
    public void fatal(String errorMessage, String tracedObject, Throwable t) {
        this.auditSystemEvent(LogEventHelper.createAuditLogEvent4Error(errorMessage, tracedObject, t));
        if (this.isFatalEnabled()) {
            this.traceLogger.log((Priority)Level.FATAL, (Object)LogEventHelper.createTraceLogEvent(errorMessage, tracedObject, t, Level.FATAL));
        }
    }

    @Override
    public void error(AuditLogEvent event) {
        this.auditSystemEvent(event);
        if (this.isErrorEnabled() && event != null) {
            this.traceLogger.log((Priority)Level.ERROR, (Object)LogEventHelper.createTraceLogEvent(event, Level.ERROR));
        }
    }

    @Override
    public void error(String errorMessage, String tracedObject) {
        this.auditSystemEvent(LogEventHelper.createAuditLogEvent4Error(errorMessage, tracedObject));
        if (this.isErrorEnabled()) {
            this.traceLogger.log((Priority)Level.ERROR, (Object)LogEventHelper.createTraceLogEvent(errorMessage, tracedObject, Level.ERROR));
        }
    }

    @Override
    public void error(String errorMessage, String tracedObject, Throwable t) {
        this.auditSystemEvent(LogEventHelper.createAuditLogEvent4Error(errorMessage, tracedObject, t));
        if (this.isErrorEnabled()) {
            this.traceLogger.log((Priority)Level.ERROR, (Object)LogEventHelper.createTraceLogEvent(errorMessage, tracedObject, t, Level.ERROR));
        }
    }

    @Override
    public void warn(String message, String tracedObject) {
        if (this.isWarnEnabled()) {
            this.traceLogger.log((Priority)Level.WARN, (Object)LogEventHelper.createTraceLogEvent(message, tracedObject, Level.WARN));
        }
    }

    @Override
    public void warn(String message, String tracedObject, Throwable t) {
        if (this.isWarnEnabled()) {
            this.traceLogger.log((Priority)Level.WARN, (Object)LogEventHelper.createTraceLogEvent(message, tracedObject, t, Level.WARN));
        }
    }

    @Override
    public void info(String message, String tracedObject) {
        if (this.isInfoEnabled()) {
            this.traceLogger.log((Priority)Level.INFO, (Object)LogEventHelper.createTraceLogEvent(message, tracedObject, Level.INFO));
        }
    }

    @Override
    public void info(String message, String tracedObject, Throwable t) {
        if (this.isInfoEnabled()) {
            this.traceLogger.log((Priority)Level.INFO, (Object)LogEventHelper.createTraceLogEvent(message, tracedObject, t, Level.INFO));
        }
    }

    @Override
    public void debug(String message, String tracedObject) {
        if (this.isDebugEnabled()) {
            this.traceLogger.log((Priority)Level.DEBUG, (Object)LogEventHelper.createTraceLogEvent(message, tracedObject, Level.DEBUG));
        }
    }

    @Override
    public void debug(String message, String tracedObject, Throwable t) {
        if (this.isDebugEnabled()) {
            this.traceLogger.log((Priority)Level.DEBUG, (Object)LogEventHelper.createTraceLogEvent(message, tracedObject, t, Level.DEBUG));
        }
    }

    @Override
    public PerfLogEvent startPerfDebug(String className, String methodName, String startMessage) {
        return this.startPerfDebug(className, methodName, startMessage, LogAction.START);
    }

    @Override
    public PerfLogEvent startPerfDebug(String className, String methodName, String startMessage, LogAction action) {
        if (this.isPerfDebugEnabled()) {
            ResourceCounterSet rcs = new ResourceCounterSet(this.getPerfLogger().getName(), null);
            Log4jPerfLogEvent event = new Log4jPerfLogEvent(className, methodName, rcs);
            event.enableResourceCounter();
            event.setMessage(startMessage);
            event.setAction(action.name());
            this.perfLogger.log((Priority)Level.DEBUG, (Object)event);
            return event;
        }
        return null;
    }

    @Override
    public void stopPerfDebug(PerfLogEvent perfLogEvent, String stopMessage) {
        this.stopPerfDebug(perfLogEvent, stopMessage, LogAction.FINISH);
    }

    @Override
    public void stopPerfDebug(PerfLogEvent perfLogEvent, String stopMessage, LogAction action) {
        if (perfLogEvent == null) {
            return;
        }
        if (this.isPerfDebugEnabled() && perfLogEvent.isLog4jPerfLogEvent()) {
            Log4jPerfLogEvent event = (Log4jPerfLogEvent)perfLogEvent;
            event.disableResourceCounter();
            event.setMessage(stopMessage);
            event.setAction(action.name());
            this.perfLogger.log((Priority)Level.DEBUG, (Object)event);
        }
    }
}

