/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.decor.IValueDecoration;
import com.ibm.cognos.aurora.api.model.value.decor.ValueDecorations;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.api.util.MultiPartIdentifier;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.core.util.PropertyContainer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractDataItem
implements IDataItem {
    private IDataContainer mContainer;
    private MultiPartIdentifier mId;
    private String mName;
    private PropertyContainer mProps = new PropertyContainer();
    private IDataType mDataType;
    private IPhysicalMetadata mPhysicalMetadata;
    private final Set<IValueDecoration> mValueDecorations = new HashSet<IValueDecoration>(2);

    public AbstractDataItem() {
        this.mDataType = DataTypes.getUnknownType();
    }

    public AbstractDataItem(IDataContainer container, String name, IDataType dataType) {
        this.mContainer = container;
        this.mName = name;
        this.mDataType = dataType;
    }

    public MultiPartIdentifier getId() {
        if (null == this.mId) {
            this.mId = null == this.mContainer ? new MultiPartIdentifier(new String[]{this.mName}) : this.mContainer.getId().append(this.mName);
        }
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String[] getPropertyNames() {
        return this.mProps.getPropertyNames();
    }

    public IValue getProperty(String name) {
        return this.mProps.get(name);
    }

    public void setProperty(String name, IValue value) {
        if (null == value) {
            this.mProps.remove(name);
        } else {
            this.mProps.set(name, value);
        }
    }

    public IDataType getDataType() {
        return this.mDataType;
    }

    public void setDataType(IDataType dataType) {
        this.mDataType = dataType;
    }

    public IDataContainer getContainer() {
        return this.mContainer;
    }

    public void setContainer(IDataContainer container) {
        this.mContainer = container;
    }

    public Set<IValueDecoration> getValueDecorations() {
        return Collections.unmodifiableSet(this.mValueDecorations);
    }

    public void addValueDecoration(IValueDecoration decoration) {
        this.mValueDecorations.add(decoration);
    }

    public IValueIterator fetchUniqueValues() {
        return this.fetchUniqueValues(-1L);
    }

    public IValueIterator fetchValues(long limit) {
        throw new UnsupportedOperationException();
    }

    public IValueIterator fetchUniqueValues(long limit) {
        throw new UnsupportedOperationException();
    }

    public IPhysicalMetadata getPhysicalMetadata() {
        return this.mPhysicalMetadata;
    }

    public void setPhysicalMetadata(IPhysicalMetadata metadata) {
        this.mPhysicalMetadata = metadata;
    }

    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        EncodeUtil.writeString(out, this.mName);
        if (null != this.mDataType) {
            out.writeBoolean(true);
            DataTypes.encodeBinary((DataOutput)out, (EncoderContext)ctx, (IDataType)this.mDataType);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mPhysicalMetadata) {
            out.writeBoolean(true);
            EncodeUtil.writeString(out, this.mPhysicalMetadata.getModel().getDataSource().getName());
            EncodeUtil.writeString(out, this.mPhysicalMetadata.getInternalUniqueName());
        } else {
            out.writeBoolean(false);
        }
        this.mProps.encodeBinary(out, ctx);
        out.writeInt(this.mValueDecorations.size());
        for (IValueDecoration decor : this.mValueDecorations) {
            ValueDecorations.encodeBinary((DataOutput)out, (EncoderContext)ctx, (IValueDecoration)decor);
        }
    }

    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        this.mName = EncodeUtil.readString(in);
        this.mDataType = in.readBoolean() ? DataTypes.decodeBinary((DataInput)in, (EncoderContext)ctx) : null;
        if (in.readBoolean()) {
            if (null == this.mContainer || null == this.mContainer.getModel()) {
                throw new RuntimeException("Associative model was not available.");
            }
            IAssociativeModel model = this.mContainer.getModel();
            String dataSourceName = EncodeUtil.readString(in);
            String internalUN = EncodeUtil.readString(in);
            IPhysicalModel physModel = model.getPhysicalModel(dataSourceName);
            if (null == physModel) {
                throw new RuntimeException("Could not find physical model: " + dataSourceName);
            }
            IPhysicalMetadata physMD = physModel.lookupMetadata(internalUN);
            if (null == physMD) {
                throw new RuntimeException("Could not find physical metadata: " + internalUN);
            }
            this.setPhysicalMetadata(physModel.lookupMetadata(internalUN));
        }
        this.mProps.decodeBinary(in, ctx);
        this.mValueDecorations.clear();
        int numDecorations = in.readInt();
        for (int i = 0; i < numDecorations; ++i) {
            this.mValueDecorations.add(ValueDecorations.decodeBinary((DataInput)in, (EncoderContext)ctx));
        }
    }

    public String toString() {
        return this.mName;
    }
}

