/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.api.util.MultiPartIdentifier;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.core.util.PropertyContainer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DataContainer
implements IDataContainer {
    private final IAssociativeModel mModel;
    private final IDataContainer mParent;
    private final List<IDataContainer> mChildren = new ArrayList<IDataContainer>();
    private String mName;
    private MultiPartIdentifier mId;
    private String mType;
    private final List<IDataItem> mDataItems = new ArrayList<IDataItem>();
    private final List<INode> mNodes = new ArrayList<INode>();
    private PropertyContainer mProps = new PropertyContainer();

    public DataContainer(IAssociativeModel model) {
        this.mModel = model;
        this.mParent = null;
    }

    public DataContainer(IAssociativeModel model, IDataContainer parent) {
        this.mModel = model;
        this.mParent = parent;
    }

    public DataContainer(IAssociativeModel model, IDataContainer parent, String name, String type) {
        this.mModel = model;
        this.mParent = parent;
        this.mName = name;
        this.mType = type;
    }

    public IQueryLogicalStorage getQLS() {
        return this.mModel.getQLS();
    }

    public IAssociativeModel getModel() {
        return this.mModel;
    }

    public MultiPartIdentifier getId() {
        if (null == this.mId) {
            this.mId = null == this.mParent ? new MultiPartIdentifier(new String[]{this.mName}) : this.mParent.getId().append(this.mName);
        }
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public String getType() {
        return this.mType;
    }

    public IDataContainer getParent() {
        return this.mParent;
    }

    public List<IDataContainer> getChildren() {
        return this.mChildren;
    }

    public IDataContainer getChild(String name) {
        for (IDataContainer c : this.mChildren) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public IDataContainer createChild(String name, String type) {
        DataContainer child = new DataContainer(this.mModel, this, name, type);
        this.mChildren.add(child);
        return child;
    }

    public List<IDataItem> getDataItems() {
        return this.mDataItems;
    }

    public void getAllDataItems(List<IDataItem> result) {
        result.addAll(this.mDataItems);
        for (IDataContainer c : this.mChildren) {
            c.getAllDataItems(result);
        }
    }

    public void addDataItem(IDataItem di) {
        this.mDataItems.add(di);
        di.setContainer((IDataContainer)this);
    }

    public IDataItem getDataItemByName(String name) {
        for (IDataItem di : this.mDataItems) {
            if (!di.getName().equals(name)) continue;
            return di;
        }
        return null;
    }

    public void removeDataItem(IDataItem di) {
        this.mDataItems.remove(di);
        if (this == di.getContainer()) {
            di.setContainer(null);
        }
    }

    public List<INode> getNodes() {
        return this.mNodes;
    }

    public void getAllNodes(List<INode> result) {
        result.addAll(this.mNodes);
        for (IDataContainer sc : this.mChildren) {
            sc.getAllNodes(result);
        }
    }

    public void addNode(INode node) {
        this.mNodes.add(node);
    }

    public void removeNode(INode node) {
        this.mNodes.remove(node);
    }

    public String[] getPropertyNames() {
        return this.mProps.getPropertyNames();
    }

    public IValue getProperty(String name) {
        return this.mProps.get(name);
    }

    public void setProperty(String name, IValue value) {
        this.mProps.set(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        ctx.push("dataContainerRef", (Object)this);
        try {
            EncodeUtil.writeString(out, this.mName);
            EncodeUtil.writeString(out, this.mType);
            this.mProps.encodeBinary(out, ctx);
            out.writeInt(this.mDataItems.size());
            for (IDataItem di : this.mDataItems) {
                EncodeUtil.writeString(out, di.getClass().getName());
                di.encodeBinary(out, ctx);
            }
            out.writeInt(this.mNodes.size());
            for (INode n : this.mNodes) {
                EncodeUtil.writeString(out, n.getId());
            }
            out.writeInt(this.mChildren.size());
            for (IDataContainer dc : this.mChildren) {
                dc.encodeBinary(out, ctx);
            }
        }
        finally {
            ctx.pop("dataContainerRef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        ctx.push("dataContainerRef", (Object)this);
        try {
            int i;
            this.mId = null;
            this.mName = EncodeUtil.readString(in);
            this.mType = EncodeUtil.readString(in);
            this.mProps.decodeBinary(in, ctx);
            this.mDataItems.clear();
            int sz = in.readInt();
            for (i = 0; i < sz; ++i) {
                IDataItem di;
                String diClassName = EncodeUtil.readString(in);
                try {
                    Class<?> clazz = Class.forName(diClassName);
                    di = (IDataItem)clazz.newInstance();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                this.addDataItem(di);
                di.decodeBinary(in, ctx);
            }
            this.mNodes.clear();
            sz = in.readInt();
            for (i = 0; i < sz; ++i) {
                String id = EncodeUtil.readString(in);
                INode n = this.mModel.findNode(id);
                if (null == n) {
                    throw new RuntimeException("Cannot find node by id: " + id);
                }
                this.mNodes.add(this.mModel.findNode(id));
            }
            this.mChildren.clear();
            sz = in.readInt();
            for (i = 0; i < sz; ++i) {
                DataContainer dc = new DataContainer(this.mModel, this);
                dc.decodeBinary(in, ctx);
                this.mChildren.add(dc);
            }
        }
        finally {
            ctx.pop("dataContainerRef");
        }
    }

    public String toString() {
        return this.mDataItems.toString();
    }
}

